/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logging.runtime;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.wildfly.swarm.bootstrap.logging.InitialLoggerManager;
import org.wildfly.swarm.bootstrap.logging.LevelNode;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.logging.LoggingFraction;
import org.wildfly.swarm.logging.runtime.LoggingParserFactory;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.runtime.AbstractParserFactory;
import org.wildfly.swarm.spi.runtime.MarshallingServerConfiguration;

public class LoggingConfiguration
extends MarshallingServerConfiguration<LoggingFraction> {
    public static final String EXTENSION_MODULE = "org.jboss.as.logging";

    public LoggingConfiguration() {
        super(LoggingFraction.class, EXTENSION_MODULE);
    }

    public LoggingFraction defaultFraction() {
        String prop = System.getProperty("swarm.logging");
        if (prop != null) {
            Level level;
            prop = prop.trim().toUpperCase();
            try {
                level = Level.valueOf((String)prop);
            }
            catch (IllegalArgumentException e) {
                return LoggingFraction.createDefaultLoggingFraction();
            }
            return LoggingFraction.createDefaultLoggingFraction((Level)level);
        }
        return LoggingFraction.createDefaultLoggingFraction();
    }

    public List<ModelNode> getList(LoggingFraction fraction) throws Exception {
        if (fraction == null) {
            fraction = this.defaultFraction();
        }
        LevelNode root = InitialLoggerManager.INSTANCE.getRoot();
        this.apply(root, fraction);
        return super.getList((Fraction)fraction);
    }

    public Optional<Map<QName, XMLElementReader<List<ModelNode>>>> getSubsystemParsers() throws Exception {
        return AbstractParserFactory.mapParserNamespaces((AbstractParserFactory)new LoggingParserFactory());
    }

    private void apply(LevelNode node, LoggingFraction fraction) {
        if (!node.getName().equals("")) {
            fraction.logger(node.getName(), l -> l.level(Level.valueOf((String)node.getLevel().toString())));
        }
        for (LevelNode each : node.getChildren()) {
            this.apply(each, fraction);
        }
    }
}

