/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logstash;

import java.util.Map;
import java.util.Properties;
import org.wildfly.swarm.SwarmProperties;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.logging.LoggingFraction;

public class LogstashFraction
implements Fraction {
    private Properties handlerProperties = new Properties();
    private Properties formatterProperties = new Properties();
    private Level level;

    public LogstashFraction() {
        this("metaData", "wildflySwarmNode=${jboss.node.name}");
        this.hostname(SwarmProperties.propertyVar((String)"logstash.host"));
    }

    public LogstashFraction(String nodeKey, String nodeValue) {
        this.formatterProperties.put(nodeKey, nodeValue);
    }

    public static Fraction createDefaultLogstashFraction() {
        return LogstashFraction.createDefaultLogstashFraction(true);
    }

    public static Fraction createDefaultLogstashFraction(boolean loggingFractionIfNoLogstash) {
        String hostname = System.getProperty("swarm.logstash.hostname");
        String port = System.getProperty("swarm.logstash.port");
        if (hostname != null && port != null) {
            return new LogstashFraction().hostname(hostname).port(port);
        }
        if (loggingFractionIfNoLogstash) {
            return LoggingFraction.createDefaultLoggingFraction();
        }
        return null;
    }

    public LogstashFraction level(Level level) {
        this.level = level;
        return this;
    }

    public LogstashFraction hostname(String hostname) {
        this.handlerProperties.put("hostname", SwarmProperties.propertyVar((String)"swarm.logstash.hostname", (String)hostname));
        return this;
    }

    public LogstashFraction port(String port) {
        this.handlerProperties.put("port", SwarmProperties.propertyVar((String)"swarm.logstash.port", (String)port));
        return this;
    }

    public LogstashFraction port(int port) {
        this.port("" + port);
        return this;
    }

    public LogstashFraction metadata(String key, String value) {
        this.formatterProperties.put(key, value);
        return this;
    }

    public void initialize(Container.InitContext initContext) {
        CustomHandler logstashHandler = new CustomHandler("logstash-handler").module("org.jboss.logmanager.ext").attributeClass("org.jboss.logmanager.ext.handlers.SocketHandler").namedFormatter("logstash").properties((Map)this.handlerProperties);
        initContext.fraction((Fraction)((LoggingFraction)new LoggingFraction().customFormatter("logstash", "org.jboss.logmanager.ext", "org.jboss.logmanager.ext.formatters.LogstashFormatter", this.formatterProperties).customHandler(logstashHandler)).rootLogger(this.level, new String[]{logstashHandler.getKey()}));
    }
}

