/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logstash.runtime;

import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.logging.LoggingFraction;
import org.wildfly.swarm.logstash.LogstashFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@Singleton
public class LogstashCustomizer
implements Customizer {
    @Inject
    @Any
    private LogstashFraction logstashFraction;
    @Inject
    @Any
    private LoggingFraction loggingFraction;
    @Inject
    @ConfigurationValue(value="swarm.logstash.hostname")
    private String hostname;
    @Inject
    @ConfigurationValue(value="swarm.logstash.port")
    private Integer port;

    public void customize() {
        try {
            int port;
            String hostname = this.hostname != null ? this.hostname : this.logstashFraction.hostname();
            int n = port = this.port != null ? this.port.intValue() : this.logstashFraction.port();
            if (hostname != null) {
                Properties handlerProps = new Properties();
                handlerProps.put("hostname", hostname);
                handlerProps.put("port", "" + port);
                CustomHandler logstashHandler = new CustomHandler("logstash-handler").module("org.jboss.logmanager.config").attributeClass("org.jboss.logmanager.config.handlers.SocketHandler").namedFormatter("logstash").properties((Map)handlerProps);
                ((LoggingFraction)this.loggingFraction.customFormatter("logstash", "org.jboss.logmanager.config", "org.jboss.logmanager.config.formatters.LogstashFormatter", this.logstashFraction.formatterProperties()).customHandler(logstashHandler)).rootLogger(this.logstashFraction.level(), new String[]{logstashHandler.getKey()});
            } else {
                System.err.println("not enabling logstash, no host set");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

