/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logstash;

import java.util.Properties;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;

@Configurable(value="swarm.logstash")
public class LogstashFraction
implements Fraction<LogstashFraction> {
    @AttributeDocumentation(value="Host name of the Logstash server")
    private Defaultable<String> hostname = Defaultable.string((String)"localhost");
    @AttributeDocumentation(value="Port of the Logstash server")
    private Defaultable<Integer> port = Defaultable.integer((int)9300);
    @AttributeDocumentation(value="Flag to enable Logstash logging")
    private Defaultable<Boolean> enabled = Defaultable.ifAnyExplicitlySet((Defaultable[])new Defaultable[]{this.hostname, this.port});
    @AttributeDocumentation(value="Logstash formatter properties")
    private Properties formatterProperties = new Properties();
    @AttributeDocumentation(value="Log level")
    private Level level;

    public LogstashFraction() {
        this("metaData", "wildflySwarmNode=${jboss.node.name}");
    }

    public LogstashFraction(String nodeKey, String nodeValue) {
        this.formatterProperties.put(nodeKey, nodeValue);
    }

    public static Fraction createDefaultLogstashFraction() {
        return new LogstashFraction();
    }

    public LogstashFraction level(Level level) {
        this.level = level;
        return this;
    }

    public Level level() {
        return this.level;
    }

    public LogstashFraction hostname(String hostname) {
        this.hostname.set((Object)hostname);
        return this;
    }

    public String hostname() {
        return (String)this.hostname.get();
    }

    public LogstashFraction port(int port) {
        this.port.set((Object)port);
        return this;
    }

    public int port() {
        return (Integer)this.port.get();
    }

    public Properties formatterProperties() {
        return this.formatterProperties;
    }

    public LogstashFraction metadata(String key, String value) {
        this.formatterProperties.put(key, value);
        return this;
    }

    public LogstashFraction enabled(boolean enable) {
        this.enabled.set((Object)enable);
        return this;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }
}

