/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mail;

import org.wildfly.swarm.config.Mail;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.config.mail.mail_session.SMTPServer;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.OutboundSocketBinding;
import org.wildfly.swarm.mail.EnhancedMailSession;
import org.wildfly.swarm.mail.EnhancedMailSessionConsumer;
import org.wildfly.swarm.mail.EnhancedSMTPServer;
import org.wildfly.swarm.mail.EnhancedSMTPServerConsumer;

public class MailFraction
extends Mail<MailFraction>
implements Fraction {
    public MailFraction mailSession(String key, EnhancedMailSessionConsumer consumer) {
        EnhancedMailSession session = new EnhancedMailSession(key);
        return (MailFraction)super.mailSession(() -> {
            if (consumer != null) {
                consumer.accept(session);
                if (session.jndiName() == null) {
                    session.jndiName("java:jboss/mail/" + key);
                }
            }
            return session;
        });
    }

    public MailFraction smtpServer(String key, EnhancedSMTPServerConsumer consumer) {
        return this.mailSession(key, session -> session.smtpServer(consumer));
    }

    public static MailFraction defaultFraction() {
        return new MailFraction().mailSession("Default", session -> session.smtpServer(server -> {
            server.host("localhost");
            server.port("25");
        }));
    }

    public void postInitialize(Container.PostInitContext initContext) {
        for (MailSession session : this.subresources().mailSessions()) {
            OutboundSocketBinding socketBinding;
            SMTPServer server = session.subresources().smtpServer();
            if (server == null || !(server instanceof EnhancedSMTPServer) || (socketBinding = ((EnhancedSMTPServer)server).outboundSocketBinding()) == null) continue;
            initContext.outboundSocketBinding(socketBinding);
        }
    }
}

