/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mail;

import javax.annotation.PostConstruct;
import org.wildfly.swarm.config.Mail;
import org.wildfly.swarm.mail.EnhancedMailSession;
import org.wildfly.swarm.mail.EnhancedMailSessionConsumer;
import org.wildfly.swarm.mail.EnhancedSMTPServerConsumer;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.jboss.as.mail")
@MarshalDMR
public class MailFraction
extends Mail<MailFraction>
implements Fraction<MailFraction> {
    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public static MailFraction defaultFraction() {
        return new MailFraction().applyDefaults();
    }

    public MailFraction applyDefaults() {
        this.mailSession("default", EnhancedMailSession::smtpServer);
        return this;
    }

    public MailFraction mailSession(String key, EnhancedMailSessionConsumer consumer) {
        EnhancedMailSession session = new EnhancedMailSession(key);
        return (MailFraction)super.mailSession(() -> {
            if (consumer != null) {
                consumer.accept(session);
                if (session.jndiName() == null) {
                    session.jndiName("java:jboss/mail/" + key);
                }
            }
            return session;
        });
    }

    public MailFraction smtpServer(String key, EnhancedSMTPServerConsumer consumer) {
        return this.mailSession(key, session -> session.smtpServer(consumer));
    }
}

