/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mail.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.config.mail.mail_session.SMTPServer;
import org.wildfly.swarm.mail.EnhancedSMTPServer;
import org.wildfly.swarm.mail.MailFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
@ApplicationScoped
public class SocketBindingCustomizer
implements Customizer {
    @Inject
    @Any
    private Instance<MailFraction> mailInstance;
    @Inject
    @Named(value="standard-sockets")
    private SocketBindingGroup group;

    public void customize() {
        if (!this.mailInstance.isUnsatisfied()) {
            MailFraction mailFraction = (MailFraction)((Object)this.mailInstance.get());
            for (MailSession session : mailFraction.subresources().mailSessions()) {
                SMTPServer server = session.subresources().smtpServer();
                if (server == null || !(server instanceof EnhancedSMTPServer) || server.outboundSocketBindingRef() != null) continue;
                String ref = "mail-smtp-" + ((EnhancedSMTPServer)server).sessionKey();
                this.group.outboundSocketBinding(new OutboundSocketBinding(ref).remoteHost(((EnhancedSMTPServer)server).host()).remotePort(((EnhancedSMTPServer)server).port()));
                ((EnhancedSMTPServer)server).outboundSocketBindingRef(ref);
            }
        }
    }
}

