/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mail;

import org.wildfly.swarm.config.Mail;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.mail.EnhancedMailSession;
import org.wildfly.swarm.mail.EnhancedMailSessionConsumer;
import org.wildfly.swarm.mail.EnhancedSMTPServerConsumer;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.jboss.as.mail")
@MarshalDMR
public class MailFraction
extends Mail<MailFraction>
implements Fraction<MailFraction> {
    public static MailFraction defaultFraction() {
        return new MailFraction().applyDefaults();
    }

    public MailFraction applyDefaults() {
        this.mailSession("default", EnhancedMailSession::smtpServer);
        return this;
    }

    @Configurable
    public MailFraction mailSession(String key, EnhancedMailSessionConsumer consumer) {
        MailSession mailSession = this.subresources().mailSession(key);
        if (mailSession == null) {
            EnhancedMailSession enhancedMailSession = new EnhancedMailSession(key);
            this.applyConsumer(enhancedMailSession, consumer, key);
            return (MailFraction)super.mailSession((MailSession)enhancedMailSession);
        }
        if (!(mailSession instanceof EnhancedMailSession)) {
            throw new IllegalStateException("Expected an instance of EnhancedMailSession: " + mailSession);
        }
        EnhancedMailSession enhancedMailSession = (EnhancedMailSession)mailSession;
        this.applyConsumer(enhancedMailSession, consumer, key);
        return this;
    }

    @Configurable
    public MailFraction smtpServer(String key, EnhancedSMTPServerConsumer consumer) {
        return this.mailSession(key, session -> session.smtpServer(consumer));
    }

    private void applyConsumer(EnhancedMailSession mailSession, EnhancedMailSessionConsumer consumer, String key) {
        if (consumer != null) {
            consumer.accept(mailSession);
            if (mailSession.jndiName() == null) {
                mailSession.jndiName("java:jboss/mail/" + key);
            }
        }
    }
}

