/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management.console.runtime;

import java.net.URL;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.management.console.ManagementConsoleFraction;
import org.wildfly.swarm.spi.api.ArtifactLookup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.undertow.WARArchive;

@Singleton
public class ManagementConsoleDeploymentProducer {
    @Inject
    private ArtifactLookup lookup;
    @Inject
    @Any
    private ManagementConsoleFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.management.console.context")
    private String context;

    @Produces
    public Archive managementConsoleWar() throws Exception {
        if (this.context == null) {
            this.context = this.fraction.contextRoot();
        }
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.as.console"));
        URL resource = module.getExportedResource("jboss-as-console-resources.jar");
        WARArchive war = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)"management-console-ui.war");
        ((ZipImporter)war.as(ZipImporter.class)).importFrom(resource.openStream());
        war.setContextRoot(this.context);
        return war;
    }
}

