/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import org.wildfly.swarm.SwarmProperties;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.container.SocketBinding;
import org.wildfly.swarm.management.EnhancedSecurityRealm;

public class ManagementFraction
extends ManagementCoreService<ManagementFraction>
implements Fraction {
    public ManagementFraction httpInterfaceManagementInterface() {
        return this.httpInterfaceManagementInterface(iface -> {});
    }

    public ManagementFraction httpInterfaceManagementInterface(HTTPInterfaceManagementInterfaceConsumer consumer) {
        return (ManagementFraction)super.httpInterfaceManagementInterface(iface -> {
            iface.consoleEnabled(Boolean.valueOf(false));
            iface.httpUpgradeEnabled(Boolean.valueOf(true));
            iface.socketBinding("management-http");
            consumer.accept(iface);
        });
    }

    public ManagementFraction securityRealm(String childKey, EnhancedSecurityRealm.Consumer consumer) {
        return (ManagementFraction)this.securityRealm(() -> {
            EnhancedSecurityRealm realm = new EnhancedSecurityRealm(childKey);
            consumer.accept(realm);
            return realm;
        });
    }

    public static ManagementFraction createDefaultFraction() {
        ManagementFraction fraction = new ManagementFraction();
        fraction.httpInterfaceManagementInterface();
        return fraction;
    }

    public void initialize(Container.InitContext initContext) {
        initContext.socketBinding(new SocketBinding("management-http").port(SwarmProperties.propertyVar((String)"swarm.management.http.port", (String)"9990")));
        initContext.socketBinding(new SocketBinding("management-https").port(SwarmProperties.propertyVar((String)"swarm.management.https.port", (String)"9993")));
    }
}

