/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import javax.annotation.PostConstruct;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.management.EnhancedSecurityRealm;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;

@MarshalDMR
public class ManagementFraction
extends ManagementCoreService<ManagementFraction>
implements Fraction<ManagementFraction> {
    public static ManagementFraction createDefaultFraction() {
        return new ManagementFraction().applyDefaults();
    }

    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public ManagementFraction applyDefaults() {
        this.httpInterfaceManagementInterface();
        return this;
    }

    public ManagementFraction httpInterfaceManagementInterface() {
        return this.httpInterfaceManagementInterface(iface -> {});
    }

    public ManagementFraction httpInterfaceManagementInterface(HTTPInterfaceManagementInterfaceConsumer consumer) {
        return (ManagementFraction)super.httpInterfaceManagementInterface(iface -> {
            iface.consoleEnabled(Boolean.valueOf(false));
            iface.httpUpgradeEnabled(Boolean.valueOf(true));
            iface.socketBinding("management-http");
            consumer.accept(iface);
        });
    }

    public ManagementFraction securityRealm(String childKey, EnhancedSecurityRealm.Consumer consumer) {
        return (ManagementFraction)this.securityRealm(() -> {
            EnhancedSecurityRealm realm = new EnhancedSecurityRealm(childKey);
            consumer.accept(realm);
            return realm;
        });
    }
}

