/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Properties;
import org.wildfly.swarm.config.management.security_realm.PlugInAuthentication;

public class InMemoryAuthentication {
    private final String realm;
    private final PlugInAuthentication plugin;

    public InMemoryAuthentication(String realm, PlugInAuthentication plugin) {
        this.realm = realm;
        this.plugin = plugin;
    }

    public void add(Properties props) {
        this.add(props, false);
    }

    public void add(Properties props, boolean plainText) {
        Enumeration<?> userNames = props.propertyNames();
        while (userNames.hasMoreElements()) {
            String userName = (String)userNames.nextElement();
            String value = props.getProperty(userName);
            this.add(userName, value, plainText);
        }
    }

    public void add(String userName, String password) {
        this.add(userName, password, false);
    }

    public void add(String userName, String password, boolean plainText) {
        if (plainText) {
            try {
                String str = userName + ":" + this.realm + ":" + password;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] hash = digest.digest(str.getBytes());
                this.add(userName, hash);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        } else {
            this.plugin.property(userName + ".hash", prop -> prop.value(password));
        }
    }

    public void add(String userName, byte[] hash) {
        this.plugin.property(userName + ".hash", prop -> {
            StringBuilder str = new StringBuilder();
            byte[] byArray = hash;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte b;
                byte i2 = b = byArray[i];
                String part = Integer.toHexString(b);
                if (part.length() > 2) {
                    part = part.substring(part.length() - 2);
                } else if (part.length() < 2) {
                    part = "0" + part;
                }
                str.append(part);
            }
            prop.value(str.toString());
        });
    }
}

