/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.management;

import javax.annotation.PostConstruct;
import org.wildfly.swarm.config.ManagementCoreService;
import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterfaceConsumer;
import org.wildfly.swarm.management.EnhancedSecurityRealm;
import org.wildfly.swarm.management.EnhancedSecurityRealmConsumer;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;

@MarshalDMR
@Configurable(value="swarm.management")
public class ManagementFraction
extends ManagementCoreService<ManagementFraction>
implements Fraction<ManagementFraction> {
    @Configurable(value="swarm.management.http.port")
    private Defaultable<Integer> httpPort = Defaultable.integer((int)9990);
    @Configurable(value="swarm.management.https.port")
    private Defaultable<Integer> httpsPort = Defaultable.integer((int)9993);
    @Configurable(value="swarm.management.http.disable")
    private Defaultable<Boolean> httpDisable = Defaultable.bool((boolean)false);

    public static ManagementFraction createDefaultFraction() {
        return new ManagementFraction().applyDefaults();
    }

    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public ManagementFraction applyDefaults() {
        this.httpInterfaceManagementInterface();
        return this;
    }

    public ManagementFraction httpInterfaceManagementInterface() {
        return this.httpInterfaceManagementInterface(iface -> {});
    }

    public ManagementFraction httpInterfaceManagementInterface(HTTPInterfaceManagementInterfaceConsumer consumer) {
        return (ManagementFraction)super.httpInterfaceManagementInterface(iface -> {
            iface.consoleEnabled(Boolean.valueOf(false));
            iface.httpUpgradeEnabled(Boolean.valueOf(true));
            iface.socketBinding("management-http");
            consumer.accept(iface);
        });
    }

    public ManagementFraction securityRealm(String childKey, EnhancedSecurityRealmConsumer consumer) {
        return (ManagementFraction)this.securityRealm(() -> {
            EnhancedSecurityRealm realm = new EnhancedSecurityRealm(childKey);
            consumer.accept(realm);
            return realm;
        });
    }

    public ManagementFraction httpPort(int port) {
        this.httpPort.set((Object)port);
        return this;
    }

    public int httpPort() {
        return (Integer)this.httpPort.get();
    }

    public ManagementFraction httpsPort(int port) {
        this.httpsPort.set((Object)port);
        return this;
    }

    public int httpsPort() {
        return (Integer)this.httpsPort.get();
    }

    public ManagementFraction httpDisable(boolean httpDisable) {
        this.httpDisable.set((Object)httpDisable);
        return this;
    }

    public boolean isHttpDisable() {
        return (Boolean)this.httpDisable.get();
    }
}

