/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging;

import org.wildfly.swarm.config.MessagingActiveMQ;
import org.wildfly.swarm.messaging.EnhancedServer;
import org.wildfly.swarm.messaging.EnhancedServerConsumer;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configuration;
import org.wildfly.swarm.spi.api.annotations.Default;

@Configuration(marshal=true, extension="org.wildfly.extension.messaging-activemq", deploymentModules={"javax.jms.api"})
public class MessagingFraction
extends MessagingActiveMQ<MessagingFraction>
implements Fraction {
    @Default
    public static MessagingFraction createDefaultFraction() {
        return new MessagingFraction().defaultServer();
    }

    public static MessagingFraction createDefaultFraction(EnhancedServerConsumer config) {
        return new MessagingFraction().defaultServer(config);
    }

    public MessagingFraction defaultServer() {
        this.findOrCreateDefaultServer();
        return this;
    }

    public MessagingFraction defaultServer(EnhancedServerConsumer config) {
        config.accept(this.findOrCreateDefaultServer());
        return this;
    }

    public MessagingFraction server(String childKey, EnhancedServerConsumer config) {
        super.server(() -> {
            EnhancedServer s = new EnhancedServer(childKey);
            config.accept(s);
            return s;
        });
        return this;
    }

    private EnhancedServer findOrCreateDefaultServer() {
        EnhancedServer server = (EnhancedServer)this.subresources().server("default");
        if (server == null) {
            this.server("default", EnhancedServer::enableInVm);
        }
        return (EnhancedServer)this.subresources().server("default");
    }
}

