/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.swarm.config.messaging.activemq.Server;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactory;

public class EnhancedServer
extends Server<EnhancedServer> {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public EnhancedServer(String key) {
        super(key);
    }

    public EnhancedServer enableInVm() {
        int serverId = COUNTER.getAndIncrement();
        this.inVmConnector("in-vm", c -> c.serverId(Integer.valueOf(serverId)));
        this.inVmAcceptor("in-vm", a -> a.serverId(Integer.valueOf(serverId)));
        this.connectionFactory(new ConnectionFactory("InVmConnectionFactory").connectors(Collections.singletonList("in-vm")).entries(Collections.singletonList("java:/ConnectionFactory")));
        this.pooledConnectionFactory(new PooledConnectionFactory("activemq-ra").entries(Collections.singletonList("java:jboss/DefaultJMSConnectionFactory")).connectors(Collections.singletonList("in-vm")).transaction("xa"));
        return this;
    }

    public EnhancedServer jmsQueue(String childKey, JMSQueueConsumer config) {
        return (EnhancedServer)super.jmsQueue(childKey, q -> {
            if (config != null) {
                config.accept(q);
            }
            if (q.entries() == null || q.entries().isEmpty()) {
                q.entry("java:/jms/queue/" + childKey);
            }
        });
    }

    public EnhancedServer jmsTopic(String childKey, JMSTopicConsumer config) {
        return (EnhancedServer)super.jmsTopic(childKey, t -> {
            if (config != null) {
                config.accept(t);
            }
            if (t.entries() == null || t.entries().isEmpty()) {
                t.entry("java:/jms/topic/" + childKey);
            }
        });
    }
}

