/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging.runtime;

import java.util.Optional;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.wildfly.swarm.messaging.MessagingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Pre;

@Pre
public class RemoteConnectionInstallingCustomizer
implements Customizer {
    @Inject
    @Any
    MessagingFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.message.remote.name")
    Optional<Boolean> remote = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.message.remote.name")
    Optional<String> remoteMqName = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.messaging.remote.jndi-name")
    Optional<String> jndiName = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.messaging.remote.host")
    Optional<String> remoteHost = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.messaging.remote.port")
    Optional<String> remotePort = Optional.empty();

    public void customize() {
        if (this.remote.isPresent() || this.remoteMqName.isPresent() || this.jndiName.isPresent() || this.remoteHost.isPresent() || this.remotePort.isPresent()) {
            this.fraction.defaultServer(server -> {
                String mqName = this.remoteMqName.orElse("remote-mq");
                server.remoteConnection(mqName, config -> {
                    this.jndiName.ifPresent(config::jndiName);
                    this.remoteHost.ifPresent(config::host);
                    this.remotePort.ifPresent(config::port);
                });
            });
        }
    }
}

