/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging.runtime;

import java.util.List;
import java.util.Optional;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.wildfly.swarm.messaging.EnhancedServer;
import org.wildfly.swarm.messaging.MessagingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
public class RemoteConnectionJndiNameCustomizer
implements Customizer {
    @Inject
    @Any
    MessagingFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.message.remote.name")
    Optional<String> mqName = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.messaging.remote.jndi-name")
    Optional<String> jndiName = Optional.empty();

    public void customize() {
        List servers = this.fraction.subresources().servers();
        String mqName = this.mqName.orElse("remote-mq");
        servers.stream().filter(e -> e instanceof EnhancedServer).forEach(server -> ((EnhancedServer)((Object)server)).remoteConnections().stream().filter(e -> e.name().equals(mqName)).findFirst().ifPresent(connection -> this.jndiName.ifPresent(connection::jndiName)));
    }
}

