/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging.runtime;

import java.util.List;
import java.util.Optional;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import org.wildfly.swarm.messaging.EnhancedServer;
import org.wildfly.swarm.messaging.MessagingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.api.OutboundSocketBinding;
import org.wildfly.swarm.spi.api.SocketBindingGroup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
public class RemoteConnectionSocketBindingCustomizer
implements Customizer {
    @Inject
    @Named(value="standard-sockets")
    SocketBindingGroup group;
    @Inject
    @Any
    MessagingFraction fraction;
    @Inject
    @ConfigurationValue(value="swarm.message.remote.name")
    Optional<String> mqName = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.messaging.remote.host")
    Optional<String> remoteHost = Optional.empty();
    @Inject
    @ConfigurationValue(value="swarm.messaging.remote.port")
    Optional<String> remotePort = Optional.empty();

    public void customize() {
        List servers = this.fraction.subresources().servers();
        String mqName = this.mqName.orElse("remote-mq");
        servers.stream().filter(e -> e instanceof EnhancedServer).forEach(server -> ((EnhancedServer)((Object)server)).remoteConnections().forEach(connection -> {
            OutboundSocketBinding binding = new OutboundSocketBinding(connection.name());
            if (connection.name().equals(mqName)) {
                binding.remoteHost(this.remoteHost.orElse(connection.host())).remotePort(this.remotePort.orElse(connection.port()));
            } else {
                binding.remoteHost(connection.host()).remotePort(connection.port());
            }
            this.group.outboundSocketBinding(binding);
        }));
    }
}

