/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.swarm.config.messaging.activemq.Server;
import org.wildfly.swarm.config.messaging.activemq.server.BroadcastGroup;
import org.wildfly.swarm.config.messaging.activemq.server.ClusterConnection;
import org.wildfly.swarm.config.messaging.activemq.server.ConnectionFactory;
import org.wildfly.swarm.config.messaging.activemq.server.DiscoveryGroup;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPAcceptor;
import org.wildfly.swarm.config.messaging.activemq.server.HTTPConnector;
import org.wildfly.swarm.config.messaging.activemq.server.JMSQueueConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.JMSTopicConsumer;
import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactory;

public class EnhancedServer
extends Server<EnhancedServer> {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public EnhancedServer(String key) {
        super(key);
    }

    public EnhancedServer enableInVm() {
        int serverId = COUNTER.getAndIncrement();
        this.inVmConnector("in-vm", c -> c.serverId(Integer.valueOf(serverId)));
        this.inVmAcceptor("in-vm", a -> a.serverId(Integer.valueOf(serverId)));
        this.connectionFactory(new ConnectionFactory("InVmConnectionFactory").connectors(Collections.singletonList("in-vm")).entries(Collections.singletonList("java:/ConnectionFactory")));
        this.pooledConnectionFactory(new PooledConnectionFactory("activemq-ra").entries(Collections.singletonList("java:jboss/DefaultJMSConnectionFactory")).connectors(Collections.singletonList("in-vm")).transaction("xa"));
        return this;
    }

    public EnhancedServer enableClustering() {
        this.enableHTTPConnections();
        this.clusterPassword("${jboss.messaging.cluster.password:CHANGE ME!!}");
        this.discoveryGroup(new DiscoveryGroup("activemq-discovery").jgroupsChannel("activemq-jgroups-cluster"));
        this.broadcastGroup(new BroadcastGroup("activemq-broadcast").jgroupsChannel("activemq-jgroups-cluster").connectors(new String[]{"http-connector"}));
        this.clusterConnection(new ClusterConnection("activemq-cluster").clusterConnectionAddress("jms").connectorName("http-connector").discoveryGroup("activemq-discovery"));
        return this;
    }

    public EnhancedServer enableRemote() {
        this.enableHTTPConnections();
        this.connectionFactory(new ConnectionFactory("RemoteConnectionFactory").connectors(Collections.singletonList("http-connector")).entries(new String[]{"java:/RemoteConnectionFactory", "java:jboss/exported/jms/RemoteConnectionFactory"}));
        return this;
    }

    private EnhancedServer enableHTTPConnections() {
        if (this.subresources().acceptor("http-acceptor") != null) {
            return this;
        }
        this.httpAcceptor(new HTTPAcceptor("http-acceptor").httpListener("default"));
        this.httpConnector(new HTTPConnector("http-connector").socketBinding("http").endpoint("http-acceptor"));
        return this;
    }

    public EnhancedServer jmsQueue(String childKey, JMSQueueConsumer config) {
        return (EnhancedServer)super.jmsQueue(childKey, q -> {
            if (config != null) {
                config.accept(q);
            }
            if (q.entries() == null || q.entries().isEmpty()) {
                q.entry("java:/jms/queue/" + childKey);
            }
        });
    }

    public EnhancedServer remoteJmsQueue(String childKey) {
        this.remoteJmsQueue(childKey, null);
        return this;
    }

    public EnhancedServer remoteJmsQueue(String childKey, JMSQueueConsumer config) {
        return (EnhancedServer)super.jmsQueue(childKey, q -> {
            if (config != null) {
                config.accept(q);
            }
            if (q.entries() == null || q.entries().isEmpty()) {
                q.entry("java:/jboss/exported/jms/queue/" + childKey);
                q.entry("java:/jms/queue/" + childKey);
            }
        });
    }

    public EnhancedServer jmsTopic(String childKey, JMSTopicConsumer config) {
        return (EnhancedServer)super.jmsTopic(childKey, t -> {
            if (config != null) {
                config.accept(t);
            }
            if (t.entries() == null || t.entries().isEmpty()) {
                t.entry("java:/jms/topic/" + childKey);
            }
        });
    }

    public EnhancedServer remoteJmsTopic(String childKey) {
        this.remoteJmsTopic(childKey, null);
        return this;
    }

    public EnhancedServer remoteJmsTopic(String childKey, JMSTopicConsumer config) {
        return (EnhancedServer)super.jmsTopic(childKey, t -> {
            if (config != null) {
                config.accept(t);
            }
            if (t.entries() == null || t.entries().isEmpty()) {
                t.entry("java:/jboss/exported/jms/topic/" + childKey);
                t.entry("java:/jms/topic/" + childKey);
            }
        });
    }
}

