/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.messaging.runtime;

import java.util.List;
import javax.inject.Inject;
import org.wildfly.swarm.messaging.EnhancedServer;
import org.wildfly.swarm.messaging.MessagingFraction;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;

@Post
public class RemoteConnectionCustomizer
implements Customizer {
    @Inject
    MessagingFraction fraction;

    public void customize() {
        List servers = this.fraction.subresources().servers();
        servers.stream().filter(e -> e instanceof EnhancedServer).forEach(server -> ((EnhancedServer)((Object)server)).remoteConnections().forEach(connection -> {
            server.remoteConnector(connection.name(), connector -> connector.socketBinding(connection.name()));
            server.pooledConnectionFactory(connection.name(), factory -> {
                factory.connectors(new String[]{connection.name()});
                factory.entry(connection.jndiName());
            });
        }));
    }
}

