/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.meta;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon31.ServletType;
import org.wildfly.swarm.spi.meta.FractionDetector;

public abstract class WebXmlFractionDetector
implements FractionDetector<InputStream> {
    private boolean detected = false;
    private boolean detectionComplete = false;
    private Collection<String> servletClasses = new HashSet<String>();

    @Override
    public String extensionToDetect() {
        return "xml";
    }

    @Override
    public boolean detectionComplete() {
        return this.detectionComplete;
    }

    @Override
    public boolean wasDetected() {
        return this.detected;
    }

    @Override
    public void detect(InputStream element) {
        long servletsFound;
        WebAppDescriptor webXMl;
        if (!this.detectionComplete() && element != null && (webXMl = (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).fromStream(element)) != null && (servletsFound = webXMl.getAllServlet().stream().map(ServletType::getServletClass).filter(c -> this.servletClasses.contains(c)).count()) > 0L) {
            this.detected = true;
            this.detectionComplete = true;
        }
    }

    public void hasServlet(String servletClass) {
        this.servletClasses.add(servletClass);
    }
}

