/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment.config;

import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.GenericConfig;

public class TimeoutConfig
extends GenericConfig<Timeout> {
    public static final String VALUE = "value";
    public static final String UNIT = "unit";
    private static Map<String, Class<?>> keys2Type = TimeoutConfig.initKeys();

    public TimeoutConfig(Method method) {
        super(Timeout.class, method);
    }

    public TimeoutConfig(AnnotatedMethod<?> annotatedMethod) {
        super(Timeout.class, annotatedMethod);
    }

    @Override
    public void validate() {
        if (this.get(VALUE, Long.class) < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Timeout on " + this.getMethodInfo() + " : value shouldn't be lower than 0");
        }
    }

    @Override
    protected Class<Timeout> getConfigType() {
        return Timeout.class;
    }

    @Override
    protected Map<String, Class<?>> getKeysToType() {
        return keys2Type;
    }

    private static Map<String, Class<?>> initKeys() {
        HashMap<String, Class> keys = new HashMap<String, Class>();
        keys.put(VALUE, Long.class);
        keys.put(UNIT, ChronoUnit.class);
        return Collections.unmodifiableMap(keys);
    }
}

