/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import com.netflix.hystrix.HystrixCommand;
import java.util.function.Supplier;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.ExecutionContextWithInvocationContext;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.RetryContext;

public class DefaultCommand
extends HystrixCommand<Object> {
    private final Supplier<Object> fallback;
    private final ExecutionContextWithInvocationContext ctx;
    private final RetryContext retryContext;
    private final boolean hasCircuitBreaker;

    protected DefaultCommand(HystrixCommand.Setter setter, ExecutionContextWithInvocationContext ctx, Supplier<Object> fallback, RetryContext retryContext, boolean hasCircuitBreaker) {
        super(setter);
        this.ctx = ctx;
        this.fallback = fallback;
        this.retryContext = retryContext;
        this.hasCircuitBreaker = hasCircuitBreaker;
    }

    protected Object run() throws Exception {
        Object res = this.hasCircuitBreaker ? this.basicRun() : this.runWithRetry();
        return res;
    }

    protected Object runWithRetry() throws Exception {
        Object res = null;
        boolean notExecuted = true;
        if (this.retryContext == null) {
            res = this.basicRun();
        } else {
            while (notExecuted && this.retryContext.shouldRetry()) {
                this.retryContext.doRetry();
                try {
                    res = this.basicRun();
                    notExecuted = false;
                }
                catch (Exception e) {
                    if (this.retryContext.shouldRetryOn(e, System.nanoTime())) {
                        this.retryContext.delayIfNeeded();
                        continue;
                    }
                    throw e;
                }
            }
        }
        return res;
    }

    private Object basicRun() throws Exception {
        return this.ctx.proceed();
    }

    protected Object getFallback() {
        if (this.fallback == null) {
            return super.getFallback();
        }
        return this.fallback.get();
    }
}

