/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Unmanaged;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.DefaultCommand;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.ExecutionContextWithInvocationContext;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.HystrixCommandBinding;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.HystrixExtension;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.RetryContext;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.SecurityActions;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.SynchronousCircuitBreaker;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.BulkheadConfig;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.CircuitBreakerConfig;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.FallbackConfig;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.FaultToleranceOperation;

@Interceptor
@HystrixCommandBinding
@Priority(value=3001)
public class HystrixCommandInterceptor {
    public static final String SYNC_CIRCUIT_BREAKER_KEY = "org_wildfly_swarm_microprofile_faulttolerance_syncCircuitBreaker";
    private static final Logger LOGGER = Logger.getLogger(HystrixCommandInterceptor.class);
    private final ConcurrentHashMap<String, HystrixCircuitBreaker> circuitBreakers;
    private final Map<Method, CommandMetadata> commandMetadataMap;
    private final Boolean nonFallBackEnable;
    private final Boolean syncCircuitBreakerEnabled;
    private final BeanManager beanManager;
    private final HystrixExtension extension;

    @Inject
    public HystrixCommandInterceptor(@ConfigProperty(name="MP_Fault_Tolerance_NonFallback_Enabled", defaultValue="true") Boolean nonFallBackEnable, @ConfigProperty(name="org_wildfly_swarm_microprofile_faulttolerance_syncCircuitBreaker", defaultValue="true") Boolean syncCircuitBreakerEnabled, BeanManager beanManager) {
        this.nonFallBackEnable = nonFallBackEnable;
        this.syncCircuitBreakerEnabled = syncCircuitBreakerEnabled;
        this.beanManager = beanManager;
        this.extension = (HystrixExtension)beanManager.getExtension(HystrixExtension.class);
        this.commandMetadataMap = new ConcurrentHashMap<Method, CommandMetadata>();
        try {
            Field field = SecurityActions.getDeclaredField(HystrixCircuitBreaker.Factory.class, "circuitBreakersByCommand");
            SecurityActions.setAccessible(field);
            this.circuitBreakers = (ConcurrentHashMap)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not obtain reference to com.netflix.hystrix.HystrixCircuitBreaker.Factory.circuitBreakersByCommand");
        }
    }

    @AroundInvoke
    public Object interceptCommand(InvocationContext ic) throws Exception {
        Method method = ic.getMethod();
        ExecutionContextWithInvocationContext ctx = new ExecutionContextWithInvocationContext(ic);
        boolean shouldRunCommand = true;
        Object res = null;
        LOGGER.tracef("FT operation intercepted: %s", (Object)method);
        CommandMetadata metadata = this.commandMetadataMap.computeIfAbsent(method, x$0 -> new CommandMetadata((Method)x$0));
        RetryContext retryContext = this.nonFallBackEnable != false && metadata.operation.hasRetry() ? new RetryContext(metadata.operation.getRetry()) : null;
        SynchronousCircuitBreaker syncCircuitBreaker = null;
        block8: while (shouldRunCommand) {
            shouldRunCommand = false;
            if (this.nonFallBackEnable.booleanValue() && this.syncCircuitBreakerEnabled.booleanValue() && metadata.hasCircuitBreaker()) {
                syncCircuitBreaker = this.getSynchronousCircuitBreaker(metadata.commandKey, metadata.operation.getCircuitBreaker());
            }
            Supplier<Object> fallback = null;
            if (retryContext == null || retryContext.isLastAttempt()) {
                fallback = metadata.getFallback(ctx);
            }
            DefaultCommand command = new DefaultCommand(metadata.setter, ctx, fallback);
            try {
                if (metadata.operation.isAsync()) {
                    LOGGER.debugf("Queue up command for async execution: %s", (Object)metadata.operation);
                    res = new AsyncFuture(command.queue());
                } else {
                    LOGGER.debugf("Sync execution: %s]", (Object)metadata.operation);
                    res = command.execute();
                }
                if (syncCircuitBreaker == null) continue;
                syncCircuitBreaker.executionSucceeded();
            }
            catch (HystrixRuntimeException e) {
                if (syncCircuitBreaker != null) {
                    syncCircuitBreaker.executionFailed();
                }
                HystrixRuntimeException.FailureType failureType = e.getFailureType();
                LOGGER.tracef("Hystrix runtime failure [%s] when invoking %s", (Object)failureType, (Object)method);
                switch (failureType) {
                    case TIMEOUT: {
                        org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException timeoutException = new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException((Throwable)e);
                        if (retryContext != null && retryContext.shouldRetry() && (shouldRunCommand = this.shouldRetry(retryContext, (Exception)timeoutException))) continue block8;
                        throw timeoutException;
                    }
                    case SHORTCIRCUIT: {
                        throw new CircuitBreakerOpenException(method.getName());
                    }
                    case REJECTED_THREAD_EXECUTION: 
                    case REJECTED_SEMAPHORE_EXECUTION: 
                    case REJECTED_SEMAPHORE_FALLBACK: {
                        BulkheadException bulkheadException = new BulkheadException((Throwable)e);
                        if (retryContext != null && retryContext.shouldRetry() && (shouldRunCommand = this.shouldRetry(retryContext, (Exception)bulkheadException))) continue block8;
                        throw bulkheadException;
                    }
                    case COMMAND_EXCEPTION: {
                        if (retryContext == null || !retryContext.shouldRetry()) break;
                        shouldRunCommand = this.shouldRetry(retryContext, this.getCause(e));
                        continue block8;
                    }
                }
                throw this.getCause(e);
            }
        }
        return res;
    }

    private Exception getCause(HystrixRuntimeException e) {
        return e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
    }

    private SynchronousCircuitBreaker getSynchronousCircuitBreaker(HystrixCommandKey commandKey, CircuitBreakerConfig config) {
        HystrixCircuitBreaker circuitBreaker = this.circuitBreakers.computeIfAbsent(commandKey.name(), key -> new SynchronousCircuitBreaker(config));
        if (circuitBreaker instanceof SynchronousCircuitBreaker) {
            return (SynchronousCircuitBreaker)circuitBreaker;
        }
        throw new IllegalStateException("Cached circuit breaker does not extend SynchronousCircuitBreaker");
    }

    private Unmanaged<FallbackHandler<?>> initUnmanaged(FaultToleranceOperation operation) {
        if (operation.hasFallback()) {
            return new Unmanaged(this.beanManager, (Class)operation.getFallback().get("value"));
        }
        return null;
    }

    private HystrixCommand.Setter initSetter(HystrixCommandKey commandKey, Method method, FaultToleranceOperation operation) {
        HystrixCommandProperties.Setter propertiesSetter = HystrixCommandProperties.Setter();
        if (operation.isAsync() || operation.hasTimeout()) {
            propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
        } else {
            propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
        }
        if (this.nonFallBackEnable.booleanValue() && operation.hasTimeout()) {
            Long value = Duration.of((Long)operation.getTimeout().get("value"), (TemporalUnit)operation.getTimeout().get("unit")).toMillis();
            if (value > Integer.MAX_VALUE) {
                LOGGER.warnf("Max supported value for @Timeout.value() is %s", (Object)Integer.MAX_VALUE);
                value = Integer.MAX_VALUE;
            }
            propertiesSetter.withExecutionTimeoutInMilliseconds(value.intValue());
            propertiesSetter.withExecutionIsolationThreadInterruptOnTimeout(true);
        } else {
            propertiesSetter.withExecutionTimeoutEnabled(false);
        }
        if (this.nonFallBackEnable.booleanValue() && operation.hasCircuitBreaker()) {
            propertiesSetter.withCircuitBreakerEnabled(true).withCircuitBreakerRequestVolumeThreshold(((Integer)operation.getCircuitBreaker().get("requestVolumeThreshold")).intValue()).withCircuitBreakerErrorThresholdPercentage(new Double((Double)operation.getCircuitBreaker().get("failureRatio") * 100.0).intValue()).withCircuitBreakerSleepWindowInMilliseconds((int)Duration.of((Long)operation.getCircuitBreaker().get("delay"), (TemporalUnit)operation.getCircuitBreaker().get("delayUnit")).toMillis());
        } else {
            propertiesSetter.withCircuitBreakerEnabled(false);
        }
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)"DefaultCommandGroup")).andCommandKey(commandKey).andCommandPropertiesDefaults(propertiesSetter);
        if (this.nonFallBackEnable.booleanValue() && operation.hasBulkhead()) {
            BulkheadConfig bulkhead = operation.getBulkhead();
            if (operation.isAsync()) {
                setter.andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)commandKey.name()));
                HystrixThreadPoolProperties.Setter threadPoolSetter = HystrixThreadPoolProperties.Setter();
                threadPoolSetter.withAllowMaximumSizeToDivergeFromCoreSize(true);
                threadPoolSetter.withCoreSize(((Integer)bulkhead.get("value")).intValue());
                threadPoolSetter.withMaximumSize(((Integer)bulkhead.get("value")).intValue());
                threadPoolSetter.withMaxQueueSize(((Integer)bulkhead.get("waitingTaskQueue")).intValue());
                threadPoolSetter.withQueueSizeRejectionThreshold(((Integer)bulkhead.get("waitingTaskQueue")).intValue());
                setter.andThreadPoolPropertiesDefaults(threadPoolSetter);
            } else {
                propertiesSetter.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
                propertiesSetter.withExecutionIsolationSemaphoreMaxConcurrentRequests(((Integer)bulkhead.get("value")).intValue());
                propertiesSetter.withExecutionIsolationThreadInterruptOnFutureCancel(true);
            }
        }
        return setter;
    }

    private boolean shouldRetry(RetryContext retryContext, Exception e) throws Exception {
        retryContext.doRetry();
        if (retryContext.shouldRetryOn(e, System.nanoTime())) {
            retryContext.delayIfNeeded();
            return true;
        }
        throw e;
    }

    class AsyncFuture
    implements Future<Object> {
        private final Future<Object> delegate;

        public AsyncFuture(Future<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return this.unwrap(null, null);
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.unwrap(timeout, unit);
        }

        private Object unwrap(Long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            Object res = this.delegate.get();
            if (res instanceof Future) {
                try {
                    Future future = (Future)res;
                    LOGGER.tracef("Unwrapping async result from: %s", (Object)future);
                    Object unwrapped = timeout != null ? future.get(timeout, unit) : future.get();
                    LOGGER.tracef("Unwrapped aync result: %s", unwrapped);
                    return unwrapped;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to get the result of: " + res);
                }
            }
            throw new IllegalStateException("A result of an @Asynchronous call must be Future: " + res);
        }
    }

    private class CommandMetadata {
        private final HystrixCommand.Setter setter;
        private final HystrixCommandKey commandKey;
        private final Unmanaged<FallbackHandler<?>> unmanaged;
        private final Method fallbackMethod;
        private final FaultToleranceOperation operation;

        public CommandMetadata(Method method) {
            String methodKey = method.toGenericString();
            FaultToleranceOperation operation = null;
            if (HystrixCommandInterceptor.this.extension != null) {
                operation = HystrixCommandInterceptor.this.extension.getFaultToleranceOperation(methodKey);
            }
            if (operation == null) {
                operation = FaultToleranceOperation.of(method);
                operation.validate();
            }
            this.operation = operation;
            this.commandKey = HystrixCommandKey.Factory.asKey((String)methodKey);
            this.setter = HystrixCommandInterceptor.this.initSetter(this.commandKey, method, operation);
            if (operation.hasFallback()) {
                FallbackConfig fallbackConfig = operation.getFallback();
                if (!fallbackConfig.get("value").equals(Fallback.DEFAULT.class)) {
                    this.unmanaged = HystrixCommandInterceptor.this.initUnmanaged(operation);
                    this.fallbackMethod = null;
                } else {
                    this.unmanaged = null;
                    String fallbackMethodName = (String)fallbackConfig.get("fallbackMethod");
                    if (!"".equals(fallbackMethodName)) {
                        try {
                            this.fallbackMethod = SecurityActions.getDeclaredMethod(method.getDeclaringClass(), fallbackMethodName, method.getParameterTypes());
                            SecurityActions.setAccessible(this.fallbackMethod);
                        }
                        catch (NoSuchMethodException | PrivilegedActionException e) {
                            throw new FaultToleranceException("Could not obtain fallback method", (Throwable)e);
                        }
                    } else {
                        this.fallbackMethod = null;
                    }
                }
            } else {
                this.unmanaged = null;
                this.fallbackMethod = null;
            }
        }

        boolean hasFallback() {
            return this.unmanaged != null || this.fallbackMethod != null;
        }

        boolean hasCircuitBreaker() {
            return this.operation.hasCircuitBreaker();
        }

        Supplier<Object> getFallback(ExecutionContextWithInvocationContext ctx) {
            if (!this.hasFallback()) {
                return null;
            }
            if (this.unmanaged != null) {
                return () -> {
                    Unmanaged.UnmanagedInstance unmanagedInstance = this.unmanaged.newInstance();
                    FallbackHandler handler = (FallbackHandler)unmanagedInstance.produce().inject().postConstruct().get();
                    try {
                        Object object = handler.handle((ExecutionContext)ctx);
                        return object;
                    }
                    finally {
                        unmanagedInstance.preDestroy().dispose();
                    }
                };
            }
            return () -> {
                try {
                    return this.fallbackMethod.invoke(ctx.getTarget(), ctx.getParameters());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new FaultToleranceException("Error during fallback method invocation", (Throwable)e);
                }
            };
        }
    }
}

