/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment.config;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static Method getAnnotationMethod(final Class<?> clazz, final String name) throws PrivilegedActionException, NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getMethod(name, new Class[0]);
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException, SecurityException {
                return clazz.getMethod(name, new Class[0]);
            }
        });
    }

    static Method getDeclaredMethod(final Class<?> clazz, final String name, final Class<?>[] parameterTypes) throws NoSuchMethodException, PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
        });
    }
}

