/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import com.netflix.hystrix.HystrixCommand;
import java.util.function.Supplier;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.ExecutionContextWithInvocationContext;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.FailureNotHandledException;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.FaultToleranceOperation;

public class DefaultCommand
extends HystrixCommand<Object> {
    private Throwable failure;
    private final FaultToleranceOperation operation;
    private final Supplier<Object> fallback;
    private final ExecutionContextWithInvocationContext ctx;

    protected DefaultCommand(HystrixCommand.Setter setter, ExecutionContextWithInvocationContext ctx, Supplier<Object> fallback, FaultToleranceOperation operation) {
        super(setter);
        this.ctx = ctx;
        this.fallback = fallback;
        this.failure = null;
        this.operation = operation;
    }

    protected Object run() throws Exception {
        try {
            return this.ctx.proceed();
        }
        catch (Throwable e) {
            this.failure = e;
            throw e;
        }
    }

    protected Object getFallback() {
        if (this.failure != null && this.operation.hasCircuitBreaker() && !this.isFailureAssignableFromAnyFailureException()) {
            throw new FailureNotHandledException(this.failure);
        }
        if (this.fallback == null) {
            return super.getFallback();
        }
        return this.fallback.get();
    }

    boolean hasFailure() {
        return this.failure != null;
    }

    private boolean isFailureAssignableFromAnyFailureException() {
        Class[] exceptions;
        for (Class exception : exceptions = (Class[])this.operation.getCircuitBreaker().get("failOn")) {
            if (!exception.isAssignableFrom(this.failure.getClass())) continue;
            return true;
        }
        return false;
    }
}

