/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.RetryConfig;

class RetryContext {
    private final RetryConfig config;
    private final AtomicInteger remainingAttempts;
    private final long start;
    private final long maxDuration;
    private final long delay;

    RetryContext(RetryConfig config) {
        this.config = config;
        this.start = System.nanoTime();
        this.remainingAttempts = new AtomicInteger((Integer)config.get("maxRetries") + 1);
        this.maxDuration = Duration.of((Long)config.get("maxDuration"), (TemporalUnit)config.get("durationUnit")).toNanos();
        this.delay = Duration.of((Long)config.get("delay"), (TemporalUnit)config.get("delayUnit")).toMillis();
    }

    RetryConfig getConfig() {
        return this.config;
    }

    Exception nextRetry(Throwable throwable) {
        this.remainingAttempts.decrementAndGet();
        if (this.shouldRetryOn(throwable, System.nanoTime())) {
            return this.delayIfNeeded();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new FaultToleranceException(throwable);
    }

    boolean shouldRetry() {
        return this.remainingAttempts.get() > 0;
    }

    boolean isLastAttempt() {
        return this.remainingAttempts.get() == 1;
    }

    boolean shouldRetryOn(Throwable exception, long time) {
        return this.shouldRetry() && (this.config.getAbortOn().length == 0 || Arrays.stream(this.config.getAbortOn()).noneMatch(ex -> ex.isAssignableFrom(exception.getClass()))) && this.retryOn(exception) && time - this.start <= this.maxDuration;
    }

    private boolean retryOn(Throwable throwable) {
        Class<?>[] retryOn = this.config.getRetryOn();
        if (retryOn.length == 0) {
            return false;
        }
        if (retryOn.length == 1) {
            return retryOn[0].isAssignableFrom(throwable.getClass());
        }
        return Arrays.stream(retryOn).anyMatch(t -> t.isAssignableFrom(throwable.getClass()));
    }

    Exception delayIfNeeded() {
        if (this.delay > 0L) {
            long jitterBase = this.config.getJitter();
            long jitter = (long)(Math.random() * (double)(jitterBase * 2L + 1L)) - jitterBase;
            try {
                TimeUnit.MILLISECONDS.sleep(this.delay + Duration.of(jitter, this.config.getJitterDelayUnit()).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return e;
            }
        }
        return null;
    }

    public String toString() {
        return "RetryContext [remainingAttempts=" + this.remainingAttempts + ", start=" + this.start + "]";
    }
}

