/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.faulttolerance.deployment;

import com.netflix.hystrix.HystrixCommand;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.ExecutionContextWithInvocationContext;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.FailureNotHandledException;
import org.wildfly.swarm.microprofile.faulttolerance.deployment.config.FaultToleranceOperation;

public class SimpleCommand
extends HystrixCommand<Object> {
    private final FaultToleranceOperation operation;
    private final Supplier<Object> fallback;
    private final ExecutionContextWithInvocationContext ctx;

    public static String getCommandKey(Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getName().replace(".", "_"));
        builder.append("#");
        builder.append(method.getName());
        builder.append("(");
        Type[] params = method.getGenericParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            builder.append(params[j].getTypeName());
            if (j >= params.length - 1) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    protected SimpleCommand(HystrixCommand.Setter setter, ExecutionContextWithInvocationContext ctx, Supplier<Object> fallback, FaultToleranceOperation operation) {
        super(setter);
        this.ctx = ctx;
        this.fallback = fallback;
        this.operation = operation;
    }

    protected Object run() throws Exception {
        return this.ctx.proceed();
    }

    protected Object getFallback() {
        Throwable failure = this.getFailedExecutionException();
        if (failure != null && this.operation.hasCircuitBreaker() && !this.isFailureAssignableFromAnyFailureException(failure)) {
            throw new FailureNotHandledException(failure);
        }
        if (this.fallback == null) {
            return super.getFallback();
        }
        return this.fallback.get();
    }

    private boolean isFailureAssignableFromAnyFailureException(Throwable failure) {
        Class[] exceptions;
        for (Class exception : exceptions = (Class[])this.operation.getCircuitBreaker().get("failOn")) {
            if (!exception.isAssignableFrom(failure.getClass())) continue;
            return true;
        }
        return false;
    }
}

