/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health.runtime;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.enterprise.inject.Vetoed;
import javax.naming.NamingException;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.health.api.Monitor;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@Vetoed
public class HttpContexts
implements HttpHandler {
    public static final String LCURL = "{";
    public static final String RCURL = "}";
    protected ThreadLocal<CountDownLatch> dispatched = new ThreadLocal();
    private AttachmentKey<List> RESPONSES = AttachmentKey.create(List.class);
    static AttachmentKey<String> TOKEN = AttachmentKey.create(String.class);
    private static final AttachmentKey<String> RESPONSE_BODY = AttachmentKey.create(String.class);
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.health");
    public static final String NODE = "/node";
    public static final String HEAP = "/heap";
    public static final String THREADS = "/threads";
    public static final String HEALTH = "/health";
    static final String EPHEMERAL_TOKEN = UUID.randomUUID().toString();
    private final Monitor monitor;
    private final HttpHandler next;
    private XnioWorker worker;
    private static final String ID = "id";
    private static final String RESULT = "result";
    private static final String DATA = "data";
    public static final String QUOTE = "\"";

    public HttpContexts(HttpHandler next) {
        try {
            this.worker = Xnio.getInstance().createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 5).set(Options.WORKER_TASK_CORE_THREADS, 5).set(Options.WORKER_TASK_MAX_THREADS, 10).set(Options.TCP_NODELAY, true).getMap());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create worker pool");
        }
        this.next = next;
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.dispatched.get() != null && this.dispatched.get().getCount() == 1L) {
            this.next.handleRequest(exchange);
            this.dispatched.set(null);
            return;
        }
        if (NODE.equals(exchange.getRequestPath())) {
            this.nodeInfo(exchange);
            return;
        }
        if (HEAP.equals(exchange.getRequestPath())) {
            this.heap(exchange);
            return;
        }
        if (THREADS.equals(exchange.getRequestPath())) {
            this.threads(exchange);
            return;
        }
        if (HEALTH.equals(exchange.getRequestPath())) {
            this.proxyRequestsCDI(exchange);
            return;
        }
        this.next.handleRequest(exchange);
    }

    private void proxyRequestsCDI(HttpServerExchange exchange) {
        Set<Object> procedures = this.monitor.getHealthDelegates();
        if (procedures.isEmpty()) {
            this.noHealthEndpoints(exchange);
            return;
        }
        ArrayList<HealthCheckResponse> responses = new ArrayList<HealthCheckResponse>();
        for (Object procedure : procedures) {
            HealthCheckResponse status = ((HealthCheck)procedure).call();
            responses.add(status);
        }
        StringBuffer sb = new StringBuffer(LCURL);
        sb.append("\"checks\": [\n");
        int i = 0;
        boolean failed = false;
        for (HealthCheckResponse resp : responses) {
            sb.append(HttpContexts.toJson(resp));
            if (!failed) {
                boolean bl = failed = resp.getState() != HealthCheckResponse.State.UP;
            }
            if (i < responses.size() - 1) {
                sb.append(",\n");
            }
            ++i;
        }
        sb.append("],\n");
        String outcome = failed ? "DOWN" : "UP";
        sb.append("\"outcome\": \"" + outcome + "\"\n");
        sb.append("}\n");
        if (failed) {
            exchange.setStatusCode(503);
        }
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(sb.toString());
        exchange.endExchange();
    }

    private void responseHeaders(HttpServerExchange exchange) {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Origin"), "*");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Headers"), "origin, content-type, accept, authorization");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Credentials"), "true");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Methods"), "GET, POST, PUT, DELETE, OPTIONS, HEAD");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Max-Age"), "1209600");
    }

    private void noHealthEndpoints(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        this.responseHeaders(exchange);
        exchange.getResponseSender().send("{\"outcome\":\"UP\", \"checks\":[]}");
        exchange.endExchange();
    }

    private void nodeInfo(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.getNodeInfo().toJSONString(false));
    }

    private void heap(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.heap().toJSONString(false));
    }

    private void threads(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.threads().toJSONString(false));
    }

    public static String toJson(HealthCheckResponse status) {
        StringBuilder sb = new StringBuilder();
        sb.append(LCURL);
        sb.append(QUOTE).append("name").append("\":\"").append(status.getName()).append("\",");
        sb.append(QUOTE).append("state").append("\":\"").append(status.getState().name()).append(QUOTE);
        if (status.getData().isPresent()) {
            sb.append(",");
            sb.append(QUOTE).append(DATA).append("\": {");
            Map atts = (Map)status.getData().get();
            int i = 0;
            for (String key : atts.keySet()) {
                sb.append(QUOTE).append(key).append("\":").append(HttpContexts.encode(atts.get(key)));
                if (i < atts.keySet().size() - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append(RCURL);
        }
        sb.append(RCURL);
        return sb.toString();
    }

    private static String encode(Object o) {
        String res = null;
        res = o instanceof String ? QUOTE + o.toString() + QUOTE : o.toString();
        return res;
    }

    public static List<String> getDefaultContextNames() {
        return Arrays.asList(NODE, HEAP, HEALTH, THREADS);
    }

    class InVMResponse {
        private int status;
        private String payload;

        public InVMResponse(int status, String payload) {
            this.status = status;
            this.payload = payload;
        }

        public int getStatus() {
            return this.status;
        }

        public String getPayload() {
            return this.payload;
        }
    }
}

