/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health.runtime;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.conduits.EmptyStreamSourceConduit;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.server.XnioBufferPoolAdaptor;
import io.undertow.util.PooledAdaptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.health.runtime.BufferingSinkConduit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedChannel;
import org.xnio.conduits.BufferedStreamSinkConduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.NullStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

final class InVMConnection
extends ServerConnection {
    private static Logger LOG = Logger.getLogger(InVMConnection.class);
    private final ByteBufferPool bufferPool;
    private final XnioWorker worker;
    private SSLSessionInfo sslSessionInfo;
    private XnioBufferPoolAdaptor poolAdaptor;
    private BufferingSinkConduit bufferSink;
    protected final List<ServerConnection.CloseListener> closeListeners = new LinkedList<ServerConnection.CloseListener>();
    private boolean closed;
    private final InetSocketAddress address;

    InVMConnection(XnioWorker worker, int port) {
        this.bufferPool = new DefaultByteBufferPool(false, 1024, 0, 0);
        this.worker = worker;
        this.address = new InetSocketAddress(port);
    }

    public void flushTo(StringBuffer sb) {
        this.bufferSink.flushTo(sb);
    }

    public Pool<ByteBuffer> getBufferPool() {
        if (this.poolAdaptor == null) {
            this.poolAdaptor = new XnioBufferPoolAdaptor(this.getByteBufferPool());
        }
        return this.poolAdaptor;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public XnioWorker getWorker() {
        return null;
    }

    public XnioIoThread getIoThread() {
        return null;
    }

    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        throw UndertowMessages.MESSAGES.outOfBandResponseNotSupported();
    }

    public boolean isContinueResponseSupported() {
        return false;
    }

    public void terminateRequestChannel(HttpServerExchange exchange) {
        LOG.trace((Object)"Terminate Mock exchange");
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public SocketAddress getPeerAddress() {
        return null;
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return null;
    }

    public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
        return null;
    }

    public SocketAddress getLocalAddress() {
        return this.address;
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.address;
    }

    public OptionMap getUndertowOptions() {
        return OptionMap.EMPTY;
    }

    public int getBufferSize() {
        return 1024;
    }

    public SSLSessionInfo getSslSessionInfo() {
        return this.sslSessionInfo;
    }

    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        this.sslSessionInfo = sessionInfo;
    }

    public void addCloseListener(ServerConnection.CloseListener listener) {
        this.closeListeners.add(listener);
    }

    public StreamConnection upgradeChannel() {
        return null;
    }

    public ConduitStreamSinkChannel getSinkChannel() {
        ConduitStreamSinkChannel sinkChannel = new ConduitStreamSinkChannel(Configurable.EMPTY, (StreamSinkConduit)new BufferedStreamSinkConduit((StreamSinkConduit)new NullStreamSinkConduit(this.worker.getIoThread()), (Pooled)new PooledAdaptor(this.bufferPool.allocate())));
        sinkChannel.setCloseListener(conduitStreamSinkChannel -> {
            for (ServerConnection.CloseListener l : this.closeListeners) {
                try {
                    l.closed((ServerConnection)this);
                }
                catch (Throwable e) {
                    UndertowLogger.REQUEST_LOGGER.exceptionInvokingCloseListener(l, e);
                }
            }
        });
        return sinkChannel;
    }

    public ConduitStreamSourceChannel getSourceChannel() {
        return new ConduitStreamSourceChannel(Configurable.EMPTY, (StreamSourceConduit)new EmptyStreamSourceConduit(this.worker.getIoThread()));
    }

    protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
        this.bufferSink = new BufferingSinkConduit(conduit);
        return this.bufferSink;
    }

    protected boolean isUpgradeSupported() {
        return false;
    }

    protected boolean isConnectSupported() {
        return false;
    }

    protected void exchangeComplete(HttpServerExchange exchange) {
        LOG.trace((Object)"InVM exchange complete");
    }

    protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
    }

    protected void setConnectListener(HttpUpgradeListener connectListener) {
    }

    protected void maxEntitySizeUpdated(HttpServerExchange exchange) {
    }

    public String getTransportProtocol() {
        return "mock";
    }
}

