/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health.deployment;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.naming.NamingException;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.health.api.Monitor;

public class HealthExtension
implements Extension {
    private static Logger log = Logger.getLogger(HealthExtension.class);
    private final Monitor monitor;
    private Collection<AnnotatedType> delegates = new ArrayList<AnnotatedType>();
    private Collection<HealthCheck> healthChecks = new ArrayList<HealthCheck>();
    private Collection<Unmanaged.UnmanagedInstance<HealthCheck>> healthCheckInstances = new ArrayList<Unmanaged.UnmanagedInstance<HealthCheck>>();

    public HealthExtension() {
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public <T> void observeResources(@Observes @WithAnnotations(value={Health.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        for (Class<?> intf : javaClass.getInterfaces()) {
            if (!intf.getName().equals(HealthCheck.class.getName())) continue;
            log.info((Object)(">> Discovered health check procedure " + javaClass));
            this.delegates.add(annotatedType);
        }
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation abd, BeanManager beanManager) {
        try {
            for (AnnotatedType delegate : this.delegates) {
                Unmanaged unmanagedHealthCheck = new Unmanaged(beanManager, delegate.getJavaClass());
                Unmanaged.UnmanagedInstance healthCheckInstance = unmanagedHealthCheck.newInstance();
                HealthCheck healthCheck = (HealthCheck)healthCheckInstance.produce().inject().postConstruct().get();
                this.healthChecks.add(healthCheck);
                this.healthCheckInstances.add((Unmanaged.UnmanagedInstance<HealthCheck>)healthCheckInstance);
                this.monitor.registerHealthBean(healthCheck);
                log.info((Object)(">> Added health bean impl " + healthCheck));
            }
            this.delegates.clear();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register health bean", e);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        this.healthChecks.forEach(healthCheck -> this.monitor.unregisterHealthBean(healthCheck));
        this.healthChecks.clear();
        this.healthCheckInstances.forEach(instance -> instance.preDestroy().dispose());
        this.healthCheckInstances.clear();
    }
}

