/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.health.runtime;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.inject.Vetoed;
import javax.naming.NamingException;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.health.api.Monitor;

@Vetoed
public class HttpContexts
implements HttpHandler {
    public static final String LCURL = "{";
    public static final String RCURL = "}";
    static AttachmentKey<String> TOKEN = AttachmentKey.create(String.class);
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.health");
    public static final String NODE = "/node";
    public static final String HEAP = "/heap";
    public static final String THREADS = "/threads";
    public static final String HEALTH = "/health";
    static final String EPHEMERAL_TOKEN = UUID.randomUUID().toString();
    private final Monitor monitor;
    private final HttpHandler next;
    private static final String DATA = "data";
    public static final String QUOTE = "\"";

    public HttpContexts(HttpHandler next) {
        this.next = next;
        try {
            this.monitor = Monitor.lookup();
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup monitor", e);
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (NODE.equals(exchange.getRequestPath())) {
            this.nodeInfo(exchange);
            return;
        }
        if (HEAP.equals(exchange.getRequestPath())) {
            this.heap(exchange);
            return;
        }
        if (THREADS.equals(exchange.getRequestPath())) {
            this.threads(exchange);
            return;
        }
        if (HEALTH.equals(exchange.getRequestPath())) {
            this.proxyRequestsCDI(exchange);
            return;
        }
        this.next.handleRequest(exchange);
    }

    private void proxyRequestsCDI(HttpServerExchange exchange) {
        Set<Object> procedures = this.monitor.getHealthDelegates();
        if (procedures.isEmpty()) {
            this.noHealthEndpoints(exchange);
            return;
        }
        ArrayList<HealthCheckResponse> responses = new ArrayList<HealthCheckResponse>();
        for (Object procedure : procedures) {
            HealthCheckResponse status = ((HealthCheck)procedure).call();
            responses.add(status);
        }
        StringBuilder sb = new StringBuilder(LCURL);
        sb.append("\"checks\": [\n");
        int i = 0;
        boolean failed = false;
        for (HealthCheckResponse resp : responses) {
            sb.append(HttpContexts.toJson(resp));
            if (!failed) {
                boolean bl = failed = resp.getState() != HealthCheckResponse.State.UP;
            }
            if (i < responses.size() - 1) {
                sb.append(",\n");
            }
            ++i;
        }
        sb.append("],\n");
        String outcome = failed ? "DOWN" : "UP";
        sb.append("\"outcome\": \"" + outcome + "\"\n");
        sb.append("}\n");
        if (failed) {
            exchange.setStatusCode(503);
        }
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(sb.toString());
        exchange.endExchange();
    }

    private void responseHeaders(HttpServerExchange exchange) {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Origin"), "*");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Headers"), "origin, content-type, accept, authorization");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Credentials"), "true");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Methods"), "GET, POST, PUT, DELETE, OPTIONS, HEAD");
        exchange.getResponseHeaders().put(new HttpString("Access-Control-Max-Age"), "1209600");
    }

    private void noHealthEndpoints(HttpServerExchange exchange) {
        exchange.setStatusCode(200);
        this.responseHeaders(exchange);
        exchange.getResponseSender().send("{\"outcome\":\"UP\", \"checks\":[]}");
        exchange.endExchange();
    }

    private void nodeInfo(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.getNodeInfo().toJSONString(false));
    }

    private void heap(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.heap().toJSONString(false));
    }

    private void threads(HttpServerExchange exchange) {
        this.responseHeaders(exchange);
        exchange.getResponseSender().send(this.monitor.threads().toJSONString(false));
    }

    public static String toJson(HealthCheckResponse status) {
        StringBuilder sb = new StringBuilder();
        sb.append(LCURL);
        sb.append(QUOTE).append("name").append("\":\"").append(status.getName()).append("\",");
        sb.append(QUOTE).append("state").append("\":\"").append(status.getState().name()).append(QUOTE);
        if (status.getData().isPresent()) {
            sb.append(",");
            sb.append(QUOTE).append(DATA).append("\": {");
            Map atts = (Map)status.getData().get();
            int i = 0;
            for (String key : atts.keySet()) {
                sb.append(QUOTE).append(key).append("\":").append(HttpContexts.encode(atts.get(key)));
                if (i < atts.keySet().size() - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append(RCURL);
        }
        sb.append(RCURL);
        return sb.toString();
    }

    private static String encode(Object o) {
        String res = null;
        res = o instanceof String ? QUOTE + o.toString() + QUOTE : o.toString();
        return res;
    }

    public static List<String> getDefaultContextNames() {
        return Arrays.asList(NODE, HEAP, HEALTH, THREADS);
    }
}

