/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.ClaimValueWrapper;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.MPJWTProducer;

public class ClaimValueProducer<T> {
    @Produces
    @Claim(value="")
    ClaimValue<T> produce(InjectionPoint ip) {
        ClaimValue cv;
        String name = this.getName(ip);
        ClaimValue returnValue = cv = MPJWTProducer.generalClaimValueProducer(name);
        Optional value = (Optional)cv.getValue();
        Type matchType = ip.getType();
        Object actualType = Object.class;
        boolean isOptional = false;
        if (matchType instanceof ParameterizedType) {
            actualType = ((ParameterizedType)matchType).getActualTypeArguments()[0];
            isOptional = matchType.getTypeName().equals(Optional.class.getTypeName());
            if (isOptional) {
                actualType = ((ParameterizedType)matchType).getActualTypeArguments()[0];
            }
        }
        if (!actualType.getTypeName().startsWith(Optional.class.getTypeName())) {
            Object nestedValue = value.orElse(null);
            ClaimValueWrapper<Optional<Object>> wrapper = new ClaimValueWrapper<Optional<Object>>(cv.getName());
            wrapper.setValue((Optional<Object>)nestedValue);
            returnValue = wrapper;
        }
        return returnValue;
    }

    String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

