/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.inject.Provider;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.ClaimProviderBeanAttributes;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.ClaimValueProducer;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.JsonValueProducer;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.MPJWTProducer;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.RawClaimTypeProducer;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.config.JWTAuthContextInfoProvider;

public class MPJWTExtension
implements Extension {
    private static Logger log = Logger.getLogger(MPJWTExtension.class);
    private HashMap<ClaimIPType, ClaimIP> claims = new HashMap();
    private Set<Type> providerOptionalTypes = new HashSet<Type>();
    private Set<Type> providerTypes = new HashSet<Type>();
    private Set<Type> rawTypes = new HashSet<Type>();
    private Set<Annotation> rawTypeQualifiers = new HashSet<Annotation>();
    private Set<Annotation> providerQualifiers = new HashSet<Annotation>();

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager beanManager) {
        log.debugf("MPJWTExtension(), added JWTPrincipalProducer", new Object[0]);
        bbd.addAnnotatedType(beanManager.createAnnotatedType(JWTAuthContextInfoProvider.class));
        bbd.addAnnotatedType(beanManager.createAnnotatedType(MPJWTProducer.class));
        bbd.addAnnotatedType(beanManager.createAnnotatedType(RawClaimTypeProducer.class));
        bbd.addAnnotatedType(beanManager.createAnnotatedType(ClaimValueProducer.class));
        bbd.addAnnotatedType(beanManager.createAnnotatedType(JsonValueProducer.class));
    }

    public void addTypeToClaimProducer(@Observes ProcessBeanAttributes pba) {
        Claim claim;
        if (pba.getAnnotated().isAnnotationPresent(Claim.class) && (claim = (Claim)pba.getAnnotated().getAnnotation(Claim.class)).value().length() == 0 && claim.standard() == Claims.UNKNOWN) {
            log.debugf("addTypeToClaimProducer: %s\n", (Object)pba.getAnnotated());
            BeanAttributes delegate = pba.getBeanAttributes();
            String name = delegate.getName();
            if (delegate.getTypes().contains(Optional.class)) {
                if (this.providerOptionalTypes.size() == 0) {
                    this.providerOptionalTypes.add((Type)((Object)Optional.class));
                }
                pba.setBeanAttributes((BeanAttributes)new ClaimProviderBeanAttributes((BeanAttributes<Object>)delegate, this.providerOptionalTypes, this.providerQualifiers));
            } else if (name != null && name.startsWith("RawClaimTypeProducer#")) {
                if (this.rawTypes.size() == 0) {
                    this.rawTypes.add((Type)((Object)Object.class));
                }
                pba.setBeanAttributes((BeanAttributes)new ClaimProviderBeanAttributes((BeanAttributes<Object>)delegate, this.rawTypes, this.rawTypeQualifiers));
                log.debugf("Setup RawClaimTypeProducer BeanAttributes", new Object[0]);
            }
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
    }

    void doProcessProducers(@Observes ProcessProducer pp) {
    }

    void processClaimValueInjections(@Observes ProcessInjectionPoint pip) {
        Class rawClass;
        log.debugf("pipRaw: %s", (Object)pip.getInjectionPoint());
        InjectionPoint ip = pip.getInjectionPoint();
        if (ip.getAnnotated().isAnnotationPresent(Claim.class) && ip.getType() instanceof Class && Modifier.isFinal((rawClass = (Class)ip.getType()).getModifiers())) {
            Claim claim = (Claim)ip.getAnnotated().getAnnotation(Claim.class);
            this.rawTypes.add(ip.getType());
            this.rawTypeQualifiers.add((Annotation)claim);
            log.debugf("+++ Added Claim raw type: %s", (Object)ip.getType());
            Class<?> declaringClass = ip.getMember().getDeclaringClass();
            Annotation[] appScoped = declaringClass.getAnnotationsByType(ApplicationScoped.class);
            Annotation[] sessionScoped = declaringClass.getAnnotationsByType(SessionScoped.class);
            if (appScoped != null && appScoped.length > 0 || sessionScoped != null && sessionScoped.length > 0) {
                String err = String.format("A raw type cannot be injected into application/session scope: IP=%s", ip);
                pip.addDefinitionError((Throwable)new DeploymentException(err));
            }
        }
    }

    void processClaimProviderInjections(@Observes ProcessInjectionPoint<?, ? extends Provider> pip) {
        log.debugf("pip: %s", (Object)pip.getInjectionPoint());
        InjectionPoint ip = pip.getInjectionPoint();
        if (ip.getAnnotated().isAnnotationPresent(Claim.class)) {
            Type innerType;
            Claim claim = (Claim)ip.getAnnotated().getAnnotation(Claim.class);
            if (claim.value().length() == 0 && claim.standard() == Claims.UNKNOWN) {
                throw new DeploymentException("@Claim at: " + ip + " has no name or valid standard enum setting");
            }
            boolean usesEnum = claim.standard() != Claims.UNKNOWN;
            String claimName = usesEnum ? claim.standard().name() : claim.value();
            log.debugf("Checking Provider Claim(%s), ip: %s", (Object)claimName, (Object)ip);
            ClaimIP claimIP = this.claims.get(claimName);
            Type matchType = ip.getType();
            Type actualType = ((ParameterizedType)matchType).getActualTypeArguments()[0];
            if (!this.optionalOrJsonValue(actualType)) {
                this.rawTypes.add(actualType);
            } else if (!actualType.getTypeName().startsWith("javax.json.Json") && !(innerType = ((ParameterizedType)actualType).getActualTypeArguments()[0]).getTypeName().startsWith("javax.json.Json")) {
                this.providerOptionalTypes.add(actualType);
                this.providerQualifiers.add((Annotation)claim);
            }
            this.rawTypeQualifiers.add((Annotation)claim);
            ClaimIPType key = new ClaimIPType(claimName, actualType);
            if (claimIP == null) {
                claimIP = new ClaimIP(actualType, actualType, false, claim);
                claimIP.setProviderSite(true);
                this.claims.put(key, claimIP);
            }
            claimIP.getInjectionPoints().add(ip);
            log.debugf("+++ Added Provider Claim(%s) ip: %s", (Object)claimName, (Object)ip);
        }
    }

    void observesAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        log.debugf("observesAfterBeanDiscovery, %s", this.claims);
        this.installClaimValueProducerMethodsViaSyntheticBeans(event, beanManager);
    }

    private void installClaimValueProducerMethodsViaSyntheticBeans(AfterBeanDiscovery event, BeanManager beanManager) {
    }

    private boolean optionalOrJsonValue(Type type) {
        boolean isOptionOrJson = type.getTypeName().startsWith(Optional.class.getTypeName()) | type.getTypeName().startsWith("javax.json.Json");
        return isOptionOrJson;
    }

    public static class ClaimIP {
        private Type matchType;
        private Type valueType;
        private boolean isOptional;
        private boolean isProviderSite;
        private boolean isNonStandard;
        private boolean isJsonValue;
        private Claim claim;
        private HashSet<InjectionPoint> injectionPoints = new HashSet();

        public ClaimIP(Type matchType, Type valueType, boolean isOptional, Claim claim) {
            this.matchType = matchType;
            this.valueType = valueType;
            this.claim = claim;
        }

        public Type getMatchType() {
            return this.matchType;
        }

        public String getClaimName() {
            return this.claim.standard() == Claims.UNKNOWN ? this.claim.value() : this.claim.standard().name();
        }

        public Claim getClaim() {
            return this.claim;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public boolean isProviderSite() {
            return this.isProviderSite;
        }

        public void setProviderSite(boolean providerSite) {
            this.isProviderSite = providerSite;
        }

        public boolean isNonStandard() {
            return this.isNonStandard;
        }

        public void setNonStandard(boolean nonStandard) {
            this.isNonStandard = nonStandard;
        }

        public boolean isJsonValue() {
            return this.isJsonValue;
        }

        public void setJsonValue(boolean jsonValue) {
            this.isJsonValue = jsonValue;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        public String toString() {
            return "ClaimIP{type=" + this.matchType + ", claim=" + this.claim + ", ips=" + this.injectionPoints + '}';
        }
    }

    public static class ClaimIPType
    implements Comparable<ClaimIPType> {
        private String claimName;
        private Type ipType;

        public ClaimIPType(String claimName, Type ipType) {
            this.claimName = claimName;
            this.ipType = ipType;
        }

        @Override
        public int compareTo(ClaimIPType o) {
            int compareTo = this.claimName.compareTo(o.claimName);
            if (compareTo == 0) {
                compareTo = this.ipType.getTypeName().compareTo(o.ipType.getTypeName());
            }
            return compareTo;
        }
    }
}

