/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth;

import io.undertow.UndertowLogger;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Locale;
import java.util.Optional;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.JWTAccount;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.MPJWTProducer;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.jaas.JWTCredential;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;

public class JWTAuthMechanism
implements AuthenticationMechanism {
    private JWTAuthContextInfo authContextInfo;
    private IdentityManager identityManager;

    public JWTAuthMechanism(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            String bearerToken = null;
            for (String current : authHeaders) {
                if (!current.toLowerCase(Locale.ENGLISH).startsWith("bearer ")) continue;
                bearerToken = current.substring(7);
                if (UndertowLogger.SECURITY_LOGGER.isTraceEnabled()) {
                    UndertowLogger.SECURITY_LOGGER.tracef("Bearer token: %s", (Object)bearerToken);
                }
                try {
                    Account account;
                    this.identityManager = securityContext.getIdentityManager();
                    JWTCredential credential = new JWTCredential(bearerToken, this.authContextInfo);
                    if (UndertowLogger.SECURITY_LOGGER.isTraceEnabled()) {
                        UndertowLogger.SECURITY_LOGGER.tracef("Bearer token: %s", (Object)bearerToken);
                    }
                    if ((account = this.identityManager.verify(credential.getName(), (Credential)credential)) != null) {
                        JsonWebToken jwtPrincipal = (JsonWebToken)account.getPrincipal();
                        MPJWTProducer.setJWTPrincipal(jwtPrincipal);
                        JWTAccount jwtAccount = new JWTAccount(jwtPrincipal, account);
                        securityContext.authenticationComplete((Account)jwtAccount, "MP-JWT", false);
                        org.jboss.security.SecurityContext jbSC = SecurityContextAssociation.getSecurityContext();
                        Subject subject = jbSC.getUtil().getSubject();
                        jbSC.getUtil().createSubjectInfo((Principal)jwtPrincipal, (Object)bearerToken, subject);
                        RoleGroup roles = this.extract(subject);
                        jbSC.getUtil().setRoles(roles);
                        UndertowLogger.SECURITY_LOGGER.debugf("Authenticated caller(%s) for path(%s) with roles: %s", (Object)credential.getName(), (Object)exchange.getRequestPath(), (Object)account.getRoles());
                        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    }
                    UndertowLogger.SECURITY_LOGGER.info((Object)"Failed to authenticate JWT bearer token");
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
                catch (Exception e) {
                    UndertowLogger.SECURITY_LOGGER.infof((Throwable)e, "Failed to validate JWT bearer token", new Object[0]);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        exchange.getResponseHeaders().add(Headers.WWW_AUTHENTICATE, "Bearer {token}");
        UndertowLogger.SECURITY_LOGGER.debugf("Sending Bearer {token} challenge for %s", (Object)exchange);
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }

    protected RoleGroup extract(Subject subject) {
        Optional<Principal> match = subject.getPrincipals().stream().filter(g -> g.getName().equals("Roles")).findFirst();
        Group rolesGroup = (Group)match.get();
        SimpleRoleGroup roles = new SimpleRoleGroup(rolesGroup);
        return roles;
    }
}

