/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.ClaimValueWrapper;

@ApplicationScoped
public class MPJWTProducer {
    private static Logger log = Logger.getLogger(MPJWTProducer.class);
    private static final String TMP = "tmp";
    private static ThreadLocal<JsonWebToken> currentPrincipal = new ThreadLocal();

    public static void setJWTPrincipal(JsonWebToken principal) {
        currentPrincipal.set(principal);
    }

    public static JsonWebToken getJWTPrincpal() {
        return currentPrincipal.get();
    }

    @PostConstruct
    void init() {
        log.debug((Object)"MPJWTProducer initialized");
    }

    void observeRequestInitialized(@Observes @Initialized(value=RequestScoped.class) Object event) {
        log.tracef("observeRequestInitialized, event=%s", event);
    }

    void observeRequestDestroyed(@Observes @Destroyed(value=RequestScoped.class) Object event) {
        log.tracef("observeRequestDestroyed, event=%s", event);
    }

    @Produces
    @RequestScoped
    JsonWebToken currentPrincipalOrNull() {
        return currentPrincipal.get();
    }

    static <T> ClaimValue<Optional<T>> generalClaimValueProducer(String name) {
        ClaimValueWrapper<Optional<Optional<T>>> wrapper = new ClaimValueWrapper<Optional<Optional<T>>>(name);
        T value = MPJWTProducer.getValue(name, false);
        Optional<T> optValue = Optional.ofNullable(value);
        wrapper.setValue(optValue);
        return wrapper;
    }

    static JsonValue generalJsonValueProducer(String name) {
        Object value = MPJWTProducer.getValue(name, false);
        JsonValue jsonValue = MPJWTProducer.wrapValue(value);
        return jsonValue;
    }

    public static <T> T getValue(String name, boolean isOptional) {
        JsonWebToken jwt = MPJWTProducer.getJWTPrincpal();
        if (jwt == null) {
            log.debugf("getValue(%s), null JsonWebToken", (Object)name);
            return null;
        }
        Optional claimValue = jwt.claim(name);
        if (!isOptional && !claimValue.isPresent()) {
            log.debugf("Failed to find Claim for: %s", (Object)name);
        }
        log.debugf("getValue(%s), isOptional=%s, claimValue=%s", (Object)name, (Object)isOptional, (Object)claimValue);
        return claimValue.orElse(null);
    }

    static JsonObject replaceMap(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = MPJWTProducer.replaceMap((Map)entryValue);
                builder.add(entry.getKey(), (JsonValue)entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)MPJWTProducer.wrapValue(entryValue);
                builder.add(entry.getKey(), (JsonValue)array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double dvalue = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), dvalue);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    static JsonValue wrapValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof JsonValue) {
            jsonValue = (JsonValue)value;
        } else if (value instanceof String) {
            jsonValue = Json.createObjectBuilder().add(TMP, value.toString()).build().getJsonString(TMP);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            jsonValue = number instanceof Long || number instanceof Integer ? Json.createObjectBuilder().add(TMP, number.longValue()).build().getJsonNumber(TMP) : Json.createObjectBuilder().add(TMP, number.doubleValue()).build().getJsonNumber(TMP);
        } else if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            jsonValue = flag != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof Collection) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            Collection list = (Collection)value;
            for (Object element : list) {
                if (element instanceof String) {
                    arrayBuilder.add(element.toString());
                    continue;
                }
                JsonValue jvalue = MPJWTProducer.wrapValue(element);
                arrayBuilder.add(jvalue);
            }
            jsonValue = arrayBuilder.build();
        } else if (value instanceof Map) {
            jsonValue = MPJWTProducer.replaceMap((Map)value);
        }
        return jsonValue;
    }
}

