/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.wildfly.swarm.microprofile.jwtauth.MicroProfileJWTAuthFraction;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.undertow.WARArchive;
import org.wildfly.swarm.undertow.descriptors.JBossWebAsset;
import org.wildfly.swarm.undertow.descriptors.SecurityConstraint;
import org.wildfly.swarm.undertow.descriptors.WebXmlAsset;

@DeploymentScoped
public class MPJWTAuthExtensionArchivePreparer
implements DeploymentProcessor {
    private static Logger log = Logger.getLogger(MPJWTAuthExtensionArchivePreparer.class);
    private static final DotName LOGIN_CONFIG = DotName.createSimple((String)"org.eclipse.microprofile.auth.LoginConfig");
    private static final DotName ROLES_ALLOWED = DotName.createSimple((String)"javax.annotation.security.RolesAllowed");
    private static final DotName DENY_ALL = DotName.createSimple((String)"javax.annotation.security.DenyAll");
    private static final DotName PERMIT_ALL = DotName.createSimple((String)"javax.annotation.security.PermitAll");
    private static final DotName PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final DotName APP_PATH = DotName.createSimple((String)"javax.ws.rs.ApplicationPath");
    private final Archive archive;
    private final IndexView index;
    private HashSet<DotName> scannedClasses = new HashSet();
    @Inject
    private MicroProfileJWTAuthFraction fraction;

    @Inject
    public MPJWTAuthExtensionArchivePreparer(Archive archive, IndexView index) {
        this.archive = archive;
        this.index = index;
    }

    public void process() throws Exception {
        WARArchive war = (WARArchive)this.archive.as(WARArchive.class);
        Collection lcAnnotations = this.index.getAnnotations(LOGIN_CONFIG);
        for (AnnotationInstance lc : lcAnnotations) {
            String realm;
            AnnotationValue authMethod = lc.value("authMethod");
            AnnotationValue realmName = lc.value("realmName");
            String string = realm = realmName != null ? realmName.asString() : "";
            if (authMethod != null) {
                WebXmlAsset webXml = war.findWebXmlAsset();
                webXml.setLoginConfig(authMethod.asString(), realm);
            }
            if (realm.length() <= 0) continue;
            JBossWebAsset jBossWeb = war.findJbossWebAsset();
            jBossWeb.setSecurityDomain(realm);
        }
        WebXmlAsset webXml = war.findWebXmlAsset();
        String appPath = "/";
        Collection appPaths = this.index.getAnnotations(APP_PATH);
        if (!appPaths.isEmpty()) {
            appPath = ((AnnotationInstance)appPaths.iterator().next()).value().asString();
        }
        Collection rolesAnnotations = this.index.getAnnotations(ROLES_ALLOWED);
        for (AnnotationInstance annotation : rolesAnnotations) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (annotation.target().kind() == AnnotationTarget.Kind.CLASS) {
                String[] roles = annotation.value().asStringArray();
                classInfo = annotation.target().asClass();
                if (this.scannedClasses.contains(classInfo.name())) continue;
                this.generateSecurityConstraints(webXml, classInfo, roles, appPath);
                continue;
            }
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || this.scannedClasses.contains((classInfo = (methodInfo = annotation.target().asMethod()).declaringClass()).name())) continue;
            String[] roles = new String[]{};
            this.generateSecurityConstraints(webXml, classInfo, roles, appPath);
        }
        if (this.fraction.getTokenIssuer().isPresent()) {
            log.debugf("Issuer: %s", this.fraction.getTokenIssuer().get());
            war.addAsManifestResource((Asset)new StringAsset((String)this.fraction.getTokenIssuer().get()), "MP-JWT-ISSUER");
        }
        if (this.fraction.getPublicKey() != null) {
            log.debugf("PublicKey: %s", (Object)this.fraction.getPublicKey());
            war.addAsManifestResource((Asset)new StringAsset(this.fraction.getPublicKey()), "MP-JWT-SIGNER");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("war: " + war.toString(true)));
        }
    }

    private void generateSecurityConstraints(WebXmlAsset webXml, ClassInfo classInfo, String[] roles, String appPath) {
        List classPermitAll;
        List paths = (List)classInfo.annotations().get(PATH);
        if (paths == null || paths.size() == 0) {
            return;
        }
        StringBuilder fullAppPath = new StringBuilder(appPath);
        if (fullAppPath.charAt(fullAppPath.length() - 1) != '/') {
            fullAppPath.append('/');
        }
        ArrayList<SecurityConstraint> newConstraints = new ArrayList<SecurityConstraint>();
        HashSet<String> allRoles = new HashSet<String>();
        allRoles.addAll(Arrays.asList(roles));
        ListIterator pathsIter = paths.listIterator();
        while (pathsIter.hasNext()) {
            AnnotationInstance ann = (AnnotationInstance)pathsIter.next();
            if (ann.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            String subpath = ann.value().asString();
            if (subpath.charAt(0) == '/') {
                fullAppPath.append(subpath.substring(1));
            } else {
                fullAppPath.append(subpath);
            }
            if (fullAppPath.charAt(fullAppPath.length() - 1) != '/') {
                fullAppPath.append('/');
            }
            pathsIter.remove();
            break;
        }
        boolean classIsDenyAll = false;
        boolean classIsPermitAll = false;
        List classDenyAll = (List)classInfo.annotations().get(DENY_ALL);
        if (classDenyAll != null) {
            for (AnnotationInstance ann : classDenyAll) {
                if (ann.target() != classInfo) continue;
                SecurityConstraint sc = webXml.protect(fullAppPath.toString() + "*").withRole("");
                newConstraints.add(sc);
                classIsDenyAll = true;
            }
        }
        if ((classPermitAll = (List)classInfo.annotations().get(PERMIT_ALL)) != null) {
            for (AnnotationInstance ann : classPermitAll) {
                if (ann.target() != classInfo) continue;
                SecurityConstraint sc = webXml.protect(fullAppPath.toString() + "*").permitAll();
                newConstraints.add(sc);
                classIsPermitAll = true;
            }
        }
        for (AnnotationInstance path : paths) {
            if (path.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            String subpath = path.value().asString();
            MethodInfo methodInfo = path.target().asMethod();
            AnnotationInstance rolesAllowed = methodInfo.annotation(ROLES_ALLOWED);
            AnnotationInstance denyAll = methodInfo.annotation(DENY_ALL);
            AnnotationInstance permitAll = methodInfo.annotation(PERMIT_ALL);
            HashSet<String> localRoles = new HashSet<String>(allRoles);
            if (denyAll != null) {
                localRoles = null;
            } else if (permitAll != null) {
                localRoles.clear();
            } else if (rolesAllowed != null) {
                localRoles.clear();
                localRoles.addAll(Arrays.asList(rolesAllowed.value().asStringArray()));
            } else if (classIsDenyAll) {
                localRoles = null;
            } else if (classIsPermitAll) {
                localRoles.clear();
            }
            String uriPath = subpath.charAt(0) == '/' ? fullAppPath.toString() + subpath.substring(1) : fullAppPath.toString() + subpath;
            int pathParamStart = uriPath.indexOf(123);
            if (pathParamStart >= 0) {
                if ((uriPath = uriPath.substring(0, pathParamStart)).charAt(uriPath.length() - 1) != '/') {
                    uriPath = uriPath + '/';
                }
                uriPath = uriPath + "*";
            }
            SecurityConstraint sc = webXml.protect(uriPath);
            if (localRoles == null) {
                sc.withRole("");
            } else if (localRoles.isEmpty()) {
                sc.permitAll();
            } else {
                localRoles.forEach(arg_0 -> ((SecurityConstraint)sc).withRole(arg_0));
            }
            newConstraints.add(sc);
        }
        if (log.isDebugEnabled()) {
            log.debugf("SecurityConstraints introduced by class: %s", (Object)classInfo.name());
            for (SecurityConstraint sc : newConstraints) {
                log.debugf("SecurityConstraint(%s), roles=%s, isPermitAll=%s", (Object)sc.urlPattern(), (Object)sc.roles(), (Object)sc.isPermitAll());
            }
        }
        this.scannedClasses.add(classInfo.name());
    }
}

