/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.form.FormParserFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.JWTAuthMechanism;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.KeyUtils;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;

@ApplicationScoped
public class JWTAuthMechanismFactory
implements AuthenticationMechanismFactory {
    private static Logger log = Logger.getLogger(JWTAuthMechanismFactory.class);

    @PostConstruct
    public void init() {
        log.debugf("init", new Object[0]);
    }

    public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
        JWTAuthContextInfo contextInfo;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Optional<Object> optContextInfo = Optional.empty();
        try {
            Instance contextInfoInstance = CDI.current().select(JWTAuthContextInfo.class, new Annotation[0]);
            contextInfo = (JWTAuthContextInfo)contextInfoInstance.get();
            optContextInfo = Optional.of(contextInfo);
        }
        catch (Exception e) {
            log.debugf((Throwable)e, "Unable to select JWTAuthContextInfo provider", new Object[0]);
        }
        if (!optContextInfo.isPresent()) {
            String publicKeyPemEnc;
            contextInfo = new JWTAuthContextInfo();
            String issuedBy = properties.get("issuedBy");
            if (issuedBy == null) {
                URL issURL = loader.getResource("/META-INF/MP-JWT-ISSUER");
                if (issURL == null) {
                    throw new IllegalStateException("No issuedBy parameter was found");
                }
                issuedBy = this.readURLContent(issURL);
                if (issuedBy == null) {
                    throw new IllegalStateException("No issuedBy parameter was found");
                }
                issuedBy = issuedBy.trim();
            }
            if ((publicKeyPemEnc = properties.get("signerPubKey")) == null) {
                URL pkURL = loader.getResource("/META-INF/MP-JWT-SIGNER");
                if (pkURL == null) {
                    throw new IllegalStateException("No signerPubKey parameter was found");
                }
                publicKeyPemEnc = this.readURLContent(pkURL);
            }
            String publicKeyPem = publicKeyPemEnc.replace(' ', '+');
            contextInfo.setIssuedBy(issuedBy);
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(publicKeyPem);
                contextInfo.setSignerKey(pk);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            contextInfo = (JWTAuthContextInfo)optContextInfo.get();
        }
        return new JWTAuthMechanism(contextInfo);
    }

    private String readURLContent(URL url) {
        StringBuilder content = new StringBuilder();
        try {
            InputStream is = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                content.append(line);
                content.append('\n');
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            log.warnf("Failed to read content from: %s, error=%s", (Object)url, (Object)e.getMessage());
        }
        return content.toString();
    }
}

