/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.MPJWTProducer;

public class JsonValueProducer {
    private static Logger log = Logger.getLogger(JsonValueProducer.class);

    @Produces
    @Claim(value="")
    public JsonString getJsonString(InjectionPoint ip) {
        return (JsonString)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonString> getOptionalJsonString(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonNumber getJsonNumber(InjectionPoint ip) {
        return (JsonNumber)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonNumber> getOptionalJsonNumber(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonArray getJsonArray(InjectionPoint ip) {
        return (JsonArray)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonArray> getOptionalJsonArray(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonObject getJsonObject(InjectionPoint ip) {
        return (JsonObject)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonObject> getOptionalJsonObject(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    public <T extends JsonValue> T getValue(InjectionPoint ip) {
        log.debugf("JsonValueProducer(%s).produce", (Object)ip);
        String name = this.getName(ip);
        JsonValue jsonValue = MPJWTProducer.generalJsonValueProducer(name);
        return (T)jsonValue;
    }

    public <T extends JsonValue> Optional<T> getOptionalValue(InjectionPoint ip) {
        log.debugf("JsonValueProducer(%s).produce", (Object)ip);
        String name = this.getName(ip);
        JsonValue jsonValue = MPJWTProducer.generalJsonValueProducer(name);
        return Optional.ofNullable(jsonValue);
    }

    String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

