/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.cdi.MPJWTProducer;

public class RawClaimTypeProducer {
    private static Logger log = Logger.getLogger(RawClaimTypeProducer.class);

    @Produces
    @Claim(value="")
    @Named(value="RawClaimTypeProducer#getValue")
    public Object getValue(InjectionPoint ip) {
        log.debugf("getValue(%s)", (Object)ip);
        String name = this.getName(ip);
        ClaimValue cv = MPJWTProducer.generalClaimValueProducer(name);
        Optional value = (Optional)cv.getValue();
        Object returnValue = value.orElse(null);
        return returnValue;
    }

    @Produces
    @Claim(value="")
    @Named(value="RawClaimTypeProducer#getOptionalValue")
    public Optional getOptionalValue(InjectionPoint ip) {
        log.debugf("getOptionalValue(%s)", (Object)ip);
        String name = this.getName(ip);
        ClaimValue cv = MPJWTProducer.generalClaimValueProducer(name);
        Optional value = (Optional)cv.getValue();
        return value;
    }

    String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

