/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.auth.config;

import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.wildfly.swarm.microprofile.jwtauth.deployment.auth.KeyUtils;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;

@Dependent
public class JWTAuthContextInfoProvider {
    @Inject
    @ConfigProperty(name="mpjwt.signerPublicKey")
    private Optional<String> publicKeyPemEnc;
    @Inject
    @ConfigProperty(name="mpjwt.issuedBy", defaultValue="NONE")
    private String issuedBy;
    @Inject
    @ConfigProperty(name="mpjwt.expGracePeriodSecs", defaultValue="60")
    private Optional<Integer> expGracePeriodSecs;

    @PostConstruct
    void init() {
    }

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        if (!this.publicKeyPemEnc.isPresent()) {
            return Optional.empty();
        }
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        try {
            RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.publicKeyPemEnc.get());
            contextInfo.setSignerKey(pk);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        if (this.issuedBy != null && !this.issuedBy.equals("NONE")) {
            contextInfo.setIssuedBy(this.issuedBy);
        }
        if (this.expGracePeriodSecs.isPresent()) {
            contextInfo.setExpGracePeriodSecs(this.expGracePeriodSecs.get());
        }
        return Optional.of(contextInfo);
    }

    @Produces
    JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

