/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.principal;

import java.net.URL;
import java.security.AccessController;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.DefaultJWTCallerPrincipalFactory;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTCallerPrincipal;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.ParseException;

public abstract class JWTCallerPrincipalFactory {
    private static Logger log = Logger.getLogger(JWTCallerPrincipalFactory.class);
    private static JWTCallerPrincipalFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JWTCallerPrincipalFactory instance() {
        if (instance != null) return instance;
        Class<JWTCallerPrincipalFactory> clazz = JWTCallerPrincipalFactory.class;
        synchronized (JWTCallerPrincipalFactory.class) {
            JWTCallerPrincipalFactory newInstance;
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            ClassLoader cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            if (cl == null) {
                cl = JWTCallerPrincipalFactory.class.getClassLoader();
            }
            if ((newInstance = JWTCallerPrincipalFactory.loadSpi(cl)) == null && cl != JWTCallerPrincipalFactory.class.getClassLoader()) {
                cl = JWTCallerPrincipalFactory.class.getClassLoader();
                newInstance = JWTCallerPrincipalFactory.loadSpi(cl);
            }
            if (newInstance == null) {
                newInstance = new DefaultJWTCallerPrincipalFactory();
            }
            instance = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static JWTCallerPrincipalFactory loadSpi(ClassLoader cl) {
        if (cl == null) {
            return null;
        }
        JWTCallerPrincipalFactory instance = JWTCallerPrincipalFactory.loadSpi(cl.getParent());
        if (instance == null) {
            ServiceLoader<JWTCallerPrincipalFactory> sl = ServiceLoader.load(JWTCallerPrincipalFactory.class, cl);
            URL u = cl.getResource("/META-INF/services/org.eclipse.microprofile.jwt.principal.JWTCallerPrincipalFactory");
            log.debugf("loadSpi, cl=%s, u=%s, sl=%s", (Object)cl, (Object)u, sl);
            try {
                for (JWTCallerPrincipalFactory spi : sl) {
                    if (!(spi instanceof JWTCallerPrincipalFactory)) continue;
                    if (instance != null) {
                        log.warn((Object)("Multiple JWTCallerPrincipalFactory implementations found: " + spi.getClass().getName() + " and " + instance.getClass().getName()));
                        break;
                    }
                    log.debugf("sl=%s, loaded=%s", sl, (Object)spi);
                    instance = spi;
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Failed to locate JWTCallerPrincipalFactory provider", e);
            }
        }
        return instance;
    }

    public static void setInstance(JWTCallerPrincipalFactory resolver) {
        instance = resolver;
    }

    public abstract JWTCallerPrincipal parse(String var1, JWTAuthContextInfo var2) throws ParseException;
}

