/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.Configurables;
import org.wildfly.swarm.spi.api.annotations.DeploymentModule;

@Configurable(value="swarm.microprofile.jwt")
@DeploymentModule(name="org.wildfly.swarm.microprofile.jwtauth", slot="deployment", export=true, metaInf=DeploymentModule.MetaInfDisposition.IMPORT)
public class MicroProfileJWTAuthFraction
implements Fraction<MicroProfileJWTAuthFraction> {
    @AttributeDocumentation(value="The URI of the JWT token issuer")
    @Configurables(value={@Configurable(value="swarm.microprofile.jwt.token.issued-by"), @Configurable(value="swarm.microprofile.jwtauth.token.issuedBy")})
    private Defaultable<String> tokenIssuer = Defaultable.string((String)"http://localhost");
    @AttributeDocumentation(value="The public key of the JWT token signer. Can be prefixed 'file:' or 'classpath:' for key assets, otherwise the key contents are expected")
    @Configurables(value={@Configurable(value="swarm.microprofile.jwt.token.signer-pub-key"), @Configurable(value="swarm.microprofile.jwtauth.token.signerPubKey")})
    private String publicKey;
    @AttributeDocumentation(value="The JWT token expiration grace period in seconds ")
    @Configurables(value={@Configurable(value="swarm.microprofile.jwt.token.exp-grace-period"), @Configurable(value="swarm.microprofile.jwtauth.token.expGracePeriod")})
    private Defaultable<Integer> expGracePeriodSecs = Defaultable.integer((int)60);
    @AttributeDocumentation(value="The JWKS URI from which to load public keys (if 'signer-pub-key' is set, this setting is ignored).")
    @Configurable(value="swarm.microprofile.jwt.token.jwks-uri")
    private String jwksUri;
    @AttributeDocumentation(value="The interval at which the JWKS URI should be queried for keys (in minutes).")
    @Configurable(value="swarm.microprofile.jwt.token.jwks-refresh-interval")
    private Defaultable<Integer> jwksRefreshInterval = Defaultable.integer((int)60);
    @AttributeDocumentation(value="If a JAX-RS resource has no class-level security metadata, then if this property is set to `true` and at least one resource method has security metadata all other resource methods without security metadata have an implicit `@DenyAll`, otherwise resource methods without security metadata are not secured")
    @Configurable(value="swarm.microprofile.jwt.default-missing-method-permissions-deny-access")
    private Defaultable<Boolean> defaultMissingMethodPermissionsDenyAccess = Defaultable.bool((boolean)true);

    public Defaultable<String> getTokenIssuer() {
        return this.tokenIssuer;
    }

    public void setTokenIssuer(Defaultable<String> tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Defaultable<Integer> getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public void setExpGracePeriodSecs(Defaultable<Integer> expGracePeriodSecs) {
        this.expGracePeriodSecs = expGracePeriodSecs;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public Defaultable<Integer> getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public void setJwksRefreshInterval(Defaultable<Integer> jwksRefreshInterval) {
        this.jwksRefreshInterval = jwksRefreshInterval;
    }

    public boolean isDefaultMissingMethodPermissionsDenyAccess() {
        return (Boolean)this.defaultMissingMethodPermissionsDenyAccess.get();
    }
}

