/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.jwtauth.deployment.principal;

import java.security.Key;
import java.util.List;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.DefaultJWTCallerPrincipal;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTAuthContextInfo;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTCallerPrincipal;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.JWTCallerPrincipalFactory;
import org.wildfly.swarm.microprofile.jwtauth.deployment.principal.ParseException;

public class DefaultJWTCallerPrincipalFactory
extends JWTCallerPrincipalFactory {
    @Override
    public JWTCallerPrincipal parse(String token, JWTAuthContextInfo authContextInfo) throws ParseException {
        DefaultJWTCallerPrincipal principal;
        try {
            JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireExpirationTime().setRequireSubject().setSkipDefaultAudienceValidation().setExpectedIssuer(authContextInfo.getIssuedBy()).setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"}));
            if (authContextInfo.getSignerKey() != null) {
                builder.setVerificationKey((Key)authContextInfo.getSignerKey());
            } else {
                List<JsonWebKey> jsonWebKeys = authContextInfo.loadJsonWebKeys();
                builder.setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver(jsonWebKeys));
            }
            if (authContextInfo.getExpGracePeriodSecs() > 0) {
                builder.setAllowedClockSkewInSeconds(authContextInfo.getExpGracePeriodSecs());
            } else {
                builder.setEvaluationTime(NumericDate.fromSeconds((long)0L));
            }
            JwtConsumer jwtConsumer = builder.build();
            JwtContext jwtContext = jwtConsumer.process(token);
            String type = ((JsonWebStructure)jwtContext.getJoseObjects().get(0)).getHeader("typ");
            jwtConsumer.processContext(jwtContext);
            JwtClaims claimsSet = jwtContext.getJwtClaims();
            String principalName = (String)claimsSet.getClaimValue("upn", String.class);
            if (principalName == null && (principalName = (String)claimsSet.getClaimValue("preferred_username", String.class)) == null) {
                principalName = claimsSet.getSubject();
            }
            claimsSet.setClaim(Claims.raw_token.name(), (Object)token);
            principal = new DefaultJWTCallerPrincipal(token, type, claimsSet, principalName);
        }
        catch (InvalidJwtException e) {
            throw new ParseException("Failed to verify token", e);
        }
        catch (MalformedClaimException e) {
            throw new ParseException("Failed to verify token claims", e);
        }
        return principal;
    }
}

