/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.jboss.as.controller.ModelController;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.swarm.microprofile.metrics.runtime.ConfigReader;
import org.wildfly.swarm.microprofile.metrics.runtime.ExtendedMetadata;
import org.wildfly.swarm.microprofile.metrics.runtime.JmxWorker;
import org.wildfly.swarm.microprofile.metrics.runtime.MetadataList;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricRegistryFactory;
import org.wildfly.swarm.microprofile.metrics.runtime.Tag;
import org.wildfly.swarm.microprofile.metrics.runtime.mbean.MCounterImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.mbean.MGaugeImpl;

public class MetricsService
implements Service<MetricsService> {
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"swarm", "mp-metrics"});
    private final InjectedValue<ServerEnvironment> serverEnvironmentValue = new InjectedValue();
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();

    public void start(StartContext context) throws StartException {
        this.initBaseAndVendorConfiguration();
        LOG.info((Object)"MicroProfile-Metrics started");
    }

    private void initBaseAndVendorConfiguration() {
        InputStream is = this.getClass().getResourceAsStream("mapping.yml");
        if (is != null) {
            Metric type;
            ConfigReader cr = new ConfigReader();
            MetadataList ml = cr.readConfig(is);
            String globalTagsFromEnv = System.getenv("MP_METRICS_TAGS");
            List<Tag> globalTags = this.convertToTags(globalTagsFromEnv);
            JmxWorker.instance().expandMultiValueEntries(ml.getBase());
            JmxWorker.instance().expandMultiValueEntries(ml.getVendor());
            for (ExtendedMetadata em : ml.getBase()) {
                em.processTags(globalTags);
                type = this.getType(em);
                LOG.debug((Object)("+++ registering " + (Object)((Object)em)));
                MetricRegistryFactory.getBaseRegistry().register(em.getName(), type, (Metadata)em);
            }
            for (ExtendedMetadata em : ml.getVendor()) {
                em.processTags(globalTags);
                type = this.getType(em);
                MetricRegistryFactory.getVendorRegistry().register(em.getName(), type, (Metadata)em);
            }
        } else {
            throw new IllegalStateException("Was not able to find the mapping file 'mapping.yml'");
        }
    }

    private Metric getType(ExtendedMetadata em) {
        Object out;
        switch (em.getTypeRaw()) {
            case GAUGE: {
                out = new MGaugeImpl(em.getMbean());
                break;
            }
            case COUNTER: {
                out = new MCounterImpl(em.getMbean());
                break;
            }
            default: {
                throw new IllegalStateException("Not yet supported: " + (Object)((Object)em));
            }
        }
        return out;
    }

    private List<Tag> convertToTags(String globalTagsString) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (globalTagsString != null) {
            String[] singleTags;
            for (String singleTag : singleTags = globalTagsString.split(",")) {
                tags.add(new Tag(singleTag.trim()));
            }
        }
        return tags;
    }

    public void stop(StopContext context) {
    }

    public MetricsService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Injector<ServerEnvironment> getServerEnvironmentInjector() {
        return this.serverEnvironmentValue;
    }

    public Injector<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }
}

