/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.deployment;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.wildfly.swarm.microprofile.metrics.deployment.MetricResolver;

@Timed
@Interceptor
@Priority(value=1010)
class TimedInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    private TimedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    private Object timedConstructor(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    private Object timedMethod(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    @AroundTimeout
    private Object timedTimeout(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object timedCallable(InvocationContext context, E element) throws Exception {
        String name = this.resolver.timed(this.bean.getBeanClass(), element).metricName();
        Timer timer = (Timer)this.registry.getMetrics().get(name);
        if (timer == null) {
            throw new IllegalStateException("No timer with name [" + name + "] found in registry [" + this.registry + "]");
        }
        Timer.Context time = timer.time();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            time.stop();
        }
    }
}

