/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.runtime.MetadataList;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;

public class ConfigReader {
    private static Logger log = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");

    public MetadataList readConfig(String mappingFile) {
        try {
            File file = new File(mappingFile);
            log.info((Object)("Loading mapping file from " + file.getAbsolutePath()));
            FileInputStream configStream = new FileInputStream(file);
            return this.readConfig(configStream);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"No configuration found");
        }
        catch (ParserException pe) {
            log.error((Object)pe);
        }
        return null;
    }

    public MetadataList readConfig(InputStream configStream) {
        Yaml yaml = new Yaml();
        MetadataList config = (MetadataList)yaml.loadAs(configStream, MetadataList.class);
        log.info((Object)"Loaded config");
        return config;
    }
}

