/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime.exporters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricRegistryFactory;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.Exporter;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.Helper;

public class JsonMetadataExporter
implements Exporter {
    private static final String QUOTE_COMMA_LF = "\",\n";
    private static final String LF = "\n";

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        StringBuilder sb = new StringBuilder();
        this.getDataForOneScope(scope, sb);
        return sb;
    }

    private void getDataForOneScope(MetricRegistry.Type scope, StringBuilder sb) {
        MetricRegistry registry = MetricRegistryFactory.get(scope);
        Map theMetadata = registry.getMetadata();
        sb.append("{");
        this.writeMetadataForMap(sb, theMetadata);
        sb.append("}");
    }

    private void writeMetadataForMap(StringBuilder sb, Map<String, Metadata> theMetadata) {
        Iterator<Map.Entry<String, Metadata>> iter = theMetadata.entrySet().iterator();
        while (iter.hasNext()) {
            Metadata entry = iter.next().getValue();
            sb.append('\"').append(entry.getName()).append('\"').append(": {\n");
            sb.append("  \"unit\": \"").append(entry.getUnit()).append(QUOTE_COMMA_LF);
            sb.append("  \"type\": \"").append(entry.getType()).append(QUOTE_COMMA_LF);
            if (entry.getDescription() != null) {
                sb.append("  \"description\": \"").append(entry.getDescription()).append(QUOTE_COMMA_LF);
            }
            if (!entry.getTags().isEmpty()) {
                sb.append("  \"tags\": \"");
                sb.append(this.getTagsAsString(entry.getTags()));
                sb.append(QUOTE_COMMA_LF);
            }
            sb.append("  \"displayName\": \"").append(entry.getDisplayName()).append("\"\n");
            if (iter.hasNext()) {
                sb.append("  },\n");
                continue;
            }
            sb.append("  }\n");
        }
    }

    private String getTagsAsString(Map<String, String> tags) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = tags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> pair = iterator.next();
            result.append(pair.getKey()).append("=").append(pair.getValue());
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    @Override
    public StringBuilder exportAllScopes() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        MetricRegistry.Type[] values = MetricRegistry.Type.values();
        int totalNonEmptyScopes = Helper.countNonEmptyScopes();
        int scopes = 0;
        for (int i = 0; i < values.length; ++i) {
            MetricRegistry.Type scope = values[i];
            MetricRegistry registry = MetricRegistryFactory.get(scope);
            if (registry.getNames().size() <= 0) continue;
            sb.append('\"').append(scope.getName().toLowerCase()).append('\"').append(" :\n");
            this.getDataForOneScope(scope, sb);
            sb.append(LF);
            if (++scopes >= totalNonEmptyScopes) continue;
            sb.append(',');
        }
        sb.append("}");
        return sb;
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, String metricName) {
        MetricRegistry registry = MetricRegistryFactory.get(scope);
        Map metadataMap = registry.getMetadata();
        Metadata m = (Metadata)metadataMap.get(metricName);
        HashMap<String, Metadata> outMap = new HashMap<String, Metadata>(1);
        outMap.put(metricName, m);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        this.writeMetadataForMap(sb, outMap);
        sb.append("}");
        sb.append(LF);
        return sb;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

