/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.as.controller.ModelController;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.microprofile.metrics.MicroprofileMetricsFraction;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricsService;
import org.wildfly.swarm.microprofile.metrics.runtime.RegistryFactoryImpl;

@ApplicationScoped
public class MetricsServiceActivator
implements ServiceActivator {
    private static final String SWARM_MP_METRICS = "swarm/metrics";
    @Inject
    @Any
    Instance<MicroprofileMetricsFraction> fractionInstance;

    public void activate(ServiceActivatorContext serviceActivatorContext) throws ServiceRegistryException {
        ServiceTarget target = serviceActivatorContext.getServiceTarget();
        MetricsService service = new MetricsService();
        ServiceBuilder metricsServiceBuilder = target.addService(MetricsService.SERVICE_NAME, (Service)service);
        RegistryFactoryImpl factory = new RegistryFactoryImpl();
        ServiceBuilder serviceBuilder = metricsServiceBuilder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.getServerEnvironmentInjector()).addDependency(ServiceName.parse((String)"jboss.eclipse.microprofile.config.config-provider")).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getModelControllerInjector());
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        BinderService binderService = new BinderService(SWARM_MP_METRICS, null, true);
        target.addService(ContextNames.buildServiceName((ServiceName)ContextNames.JBOSS_CONTEXT_SERVICE_NAME, (String)SWARM_MP_METRICS), (Service)binderService).addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addInjection((Injector)binderService.getManagedObjectInjector(), (Object)new ImmediateManagedReferenceFactory((Object)factory)).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

