/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.microprofile.metrics.runtime.exporters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Snapshot;
import org.jboss.logging.Logger;
import org.wildfly.swarm.microprofile.metrics.runtime.MetricRegistryFactory;
import org.wildfly.swarm.microprofile.metrics.runtime.Tag;
import org.wildfly.swarm.microprofile.metrics.runtime.app.HistogramImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.MeterImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.app.TimerImpl;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.Exporter;
import org.wildfly.swarm.microprofile.metrics.runtime.exporters.PrometheusUnit;

public class PrometheusExporter
implements Exporter {
    private static final String SWARM_MICROPROFILE_METRICS_OMIT_HELP_LINE = "swarm.microprofile.metrics.omitHelpLine";
    private static Logger LOG = Logger.getLogger((String)"org.wildfly.swarm.microprofile.metrics");
    private static final String LF = "\n";
    private static final String GAUGE = "gauge";
    private static final String SPACE = " ";
    private static final String SUMMARY = "summary";
    private static final String USCORE = "_";
    private static final String COUNTER = "counter";
    private static final String QUANTILE = "quantile";
    private boolean writeHelpLine;

    public PrometheusExporter() {
        Config config = ConfigProvider.getConfig();
        Optional tmp = config.getOptionalValue(SWARM_MICROPROFILE_METRICS_OMIT_HELP_LINE, Boolean.class);
        this.writeHelpLine = !tmp.isPresent() || (Boolean)tmp.get() == false;
    }

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        StringBuilder sb = new StringBuilder();
        this.getEntriesForScope(scope, sb);
        return sb;
    }

    @Override
    public StringBuilder exportAllScopes() {
        StringBuilder sb = new StringBuilder();
        for (MetricRegistry.Type scope : MetricRegistry.Type.values()) {
            this.getEntriesForScope(scope, sb);
        }
        return sb;
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, String metricName) {
        MetricRegistry registry = MetricRegistryFactory.get(scope);
        Map metricMap = registry.getMetrics();
        Metric m = (Metric)metricMap.get(metricName);
        HashMap<String, Metric> outMap = new HashMap<String, Metric>(1);
        outMap.put(metricName, m);
        StringBuilder sb = new StringBuilder();
        this.exposeEntries(scope, sb, registry, outMap);
        return sb;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    private void getEntriesForScope(MetricRegistry.Type scope, StringBuilder sb) {
        MetricRegistry registry = MetricRegistryFactory.get(scope);
        Map metricMap = registry.getMetrics();
        this.exposeEntries(scope, sb, registry, metricMap);
    }

    private void exposeEntries(MetricRegistry.Type scope, StringBuilder sb, MetricRegistry registry, Map<String, Metric> metricMap) {
        block6: for (Map.Entry<String, Metric> entry : metricMap.entrySet()) {
            String key = entry.getKey();
            Metadata md = (Metadata)registry.getMetadata().get(key);
            Metric metric = entry.getValue();
            switch (md.getTypeRaw()) {
                case GAUGE: 
                case COUNTER: {
                    key = this.getPrometheusMetricName(md, key);
                    String suffix = null;
                    if (!md.getUnit().equals("none")) {
                        suffix = USCORE + PrometheusUnit.getBaseUnitAsPrometheusString(md.getUnit());
                    }
                    this.writeHelpLine(sb, scope, key, md, suffix);
                    this.writeTypeLine(sb, scope, key, md, suffix, null);
                    this.createSimpleValueLine(sb, scope, key, md, metric);
                    continue block6;
                }
                case METERED: {
                    MeterImpl meter = (MeterImpl)metric;
                    this.writeMeterValues(sb, scope, (Metered)meter, md);
                    continue block6;
                }
                case TIMER: {
                    TimerImpl timer = (TimerImpl)metric;
                    this.writeTimerValues(sb, scope, timer, md);
                    continue block6;
                }
                case HISTOGRAM: {
                    HistogramImpl histogram = (HistogramImpl)metric;
                    this.writeHistogramValues(sb, scope, histogram, md);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Not supported: " + key);
        }
    }

    private void writeTimerValues(StringBuilder sb, MetricRegistry.Type scope, TimerImpl timer, Metadata md) {
        String unit = md.getUnit();
        String theUnit = (unit = PrometheusUnit.getBaseUnitAsPrometheusString(unit)).equals("none") ? "" : USCORE + unit;
        this.writeMeterRateValues(sb, scope, timer.getMeter(), md);
        Snapshot snapshot = timer.getSnapshot();
        this.writeSnapshotBasics(sb, scope, md, snapshot, theUnit);
        String suffix = USCORE + PrometheusUnit.getBaseUnitAsPrometheusString(md.getUnit());
        this.writeHelpLine(sb, scope, md.getName(), md, suffix);
        this.writeTypeLine(sb, scope, md.getName(), md, suffix, SUMMARY);
        this.writeValueLine(sb, scope, suffix + "_count", timer.getCount(), md);
        this.writeSnapshotQuantiles(sb, scope, md, snapshot, theUnit);
    }

    private void writeHistogramValues(StringBuilder sb, MetricRegistry.Type scope, HistogramImpl histogram, Metadata md) {
        Snapshot snapshot = histogram.getSnapshot();
        String unit = md.getUnit();
        String theUnit = (unit = PrometheusUnit.getBaseUnitAsPrometheusString(unit)).equals("none") ? "" : USCORE + unit;
        this.writeHelpLine(sb, scope, md.getName(), md, SUMMARY);
        this.writeSnapshotBasics(sb, scope, md, snapshot, theUnit);
        this.writeTypeLine(sb, scope, md.getName(), md, theUnit, SUMMARY);
        this.writeValueLine(sb, scope, theUnit + "_count", histogram.getCount(), md);
        this.writeSnapshotQuantiles(sb, scope, md, snapshot, theUnit);
    }

    private void writeSnapshotBasics(StringBuilder sb, MetricRegistry.Type scope, Metadata md, Snapshot snapshot, String unit) {
        this.writeTypeAndValue(sb, scope, "_min" + unit, snapshot.getMin(), GAUGE, md);
        this.writeTypeAndValue(sb, scope, "_max" + unit, snapshot.getMax(), GAUGE, md);
        this.writeTypeAndValue(sb, scope, "_mean" + unit, snapshot.getMean(), GAUGE, md);
        this.writeTypeAndValue(sb, scope, "_stddev" + unit, snapshot.getStdDev(), GAUGE, md);
    }

    private void writeSnapshotQuantiles(StringBuilder sb, MetricRegistry.Type scope, Metadata md, Snapshot snapshot, String unit) {
        this.writeValueLine(sb, scope, unit, snapshot.getMedian(), md, new Tag(QUANTILE, "0.5"));
        this.writeValueLine(sb, scope, unit, snapshot.get75thPercentile(), md, new Tag(QUANTILE, "0.75"));
        this.writeValueLine(sb, scope, unit, snapshot.get95thPercentile(), md, new Tag(QUANTILE, "0.95"));
        this.writeValueLine(sb, scope, unit, snapshot.get98thPercentile(), md, new Tag(QUANTILE, "0.98"));
        this.writeValueLine(sb, scope, unit, snapshot.get99thPercentile(), md, new Tag(QUANTILE, "0.99"));
        this.writeValueLine(sb, scope, unit, snapshot.get999thPercentile(), md, new Tag(QUANTILE, "0.999"));
    }

    private void writeMeterValues(StringBuilder sb, MetricRegistry.Type scope, Metered metric, Metadata md) {
        this.writeHelpLine(sb, scope, md.getName(), md, "_total");
        this.writeTypeAndValue(sb, scope, "_total", metric.getCount(), COUNTER, md);
        this.writeMeterRateValues(sb, scope, metric, md);
    }

    private void writeMeterRateValues(StringBuilder sb, MetricRegistry.Type scope, Metered metric, Metadata md) {
        this.writeTypeAndValue(sb, scope, "_rate_per_second", metric.getMeanRate(), GAUGE, md);
        this.writeTypeAndValue(sb, scope, "_one_min_rate_per_second", metric.getOneMinuteRate(), GAUGE, md);
        this.writeTypeAndValue(sb, scope, "_five_min_rate_per_second", metric.getFiveMinuteRate(), GAUGE, md);
        this.writeTypeAndValue(sb, scope, "_fifteen_min_rate_per_second", metric.getFifteenMinuteRate(), GAUGE, md);
    }

    private void writeTypeAndValue(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, String type, Metadata md) {
        String key = md.getName();
        this.writeTypeLine(sb, scope, key, md, suffix, type);
        this.writeValueLine(sb, scope, suffix, valueRaw, md);
    }

    private void writeValueLine(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, Metadata md) {
        this.writeValueLine(sb, scope, suffix, valueRaw, md, null);
    }

    private void writeValueLine(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, Metadata md, Tag extraTag) {
        String name = md.getName();
        name = this.getPrometheusMetricName(md, name);
        this.fillBaseName(sb, scope, name);
        if (suffix != null) {
            sb.append(suffix);
        }
        HashMap<String, String> tags = new HashMap<String, String>(md.getTags());
        if (extraTag != null) {
            tags.put(extraTag.getKey(), extraTag.getValue());
        }
        if (!tags.isEmpty()) {
            this.addTags(sb, tags);
        }
        sb.append(SPACE);
        sb.append(PrometheusUnit.scaleToBase(md.getUnit(), valueRaw)).append(LF);
    }

    private void addTags(StringBuilder sb, Map<String, String> tags) {
        Iterator<Map.Entry<String, String>> iter = tags.entrySet().iterator();
        sb.append("{");
        while (iter.hasNext()) {
            Map.Entry<String, String> tag = iter.next();
            sb.append(tag.getKey()).append("=\"").append(tag.getValue()).append("\"");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
    }

    private void fillBaseName(StringBuilder sb, MetricRegistry.Type scope, String key) {
        sb.append(scope.getName().toLowerCase()).append(":").append(key);
    }

    private void writeHelpLine(StringBuilder sb, MetricRegistry.Type scope, String key, Metadata md, String suffix) {
        if (this.writeHelpLine && md.getDescription() != null) {
            sb.append("# HELP ");
            sb.append(scope.getName().toLowerCase());
            sb.append(':').append(this.getPrometheusMetricName(md, key));
            if (suffix != null) {
                sb.append(suffix);
            }
            sb.append(SPACE);
            sb.append(md.getDescription());
            sb.append(LF);
        }
    }

    private void writeTypeLine(StringBuilder sb, MetricRegistry.Type scope, String key, Metadata md, String suffix, String typeOverride) {
        sb.append("# TYPE ");
        sb.append(scope.getName().toLowerCase());
        sb.append(':').append(this.getPrometheusMetricName(md, key));
        if (suffix != null) {
            sb.append(suffix);
        }
        sb.append(SPACE);
        if (typeOverride != null) {
            sb.append(typeOverride);
        } else if (md.getTypeRaw().equals((Object)MetricType.TIMER)) {
            sb.append(SUMMARY);
        } else if (md.getTypeRaw().equals((Object)MetricType.METERED)) {
            sb.append(COUNTER);
        } else {
            sb.append(md.getType());
        }
        sb.append(LF);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createSimpleValueLine(StringBuilder sb, MetricRegistry.Type scope, String key, Metadata md, Metric metric) {
        Double valIn;
        String tags;
        this.fillBaseName(sb, scope, key);
        if (!md.getUnit().equals("none")) {
            String unit = PrometheusUnit.getBaseUnitAsPrometheusString(md.getUnit());
            sb.append(USCORE).append(unit);
        }
        if ((tags = md.getTagsAsString()) != null && !tags.isEmpty()) {
            sb.append('{').append(tags).append('}');
        }
        if (md.getTypeRaw().equals((Object)MetricType.GAUGE)) {
            Number value1 = (Number)((Gauge)metric).getValue();
            if (value1 == null) {
                LOG.warn((Object)("Value is null for " + key));
                throw new IllegalStateException("Value must not be null for " + key);
            }
            valIn = value1.doubleValue();
        } else {
            valIn = ((Counter)metric).getCount();
        }
        Double value = PrometheusUnit.scaleToBase(md.getUnit(), valIn);
        sb.append(SPACE).append(value).append(LF);
    }

    private String getPrometheusMetricName(Metadata entry, String name) {
        String out = name.replaceAll("[^\\w]+", USCORE);
        out = this.decamelize(out);
        if (entry == null) {
            throw new IllegalStateException("No entry for " + name + " found");
        }
        out = out.replace("__", USCORE);
        out = out.replace(":_", ":");
        return out;
    }

    private String decamelize(String in) {
        return in.replaceAll("(.)(\\p{Upper})", "$1_$2").toLowerCase();
    }
}

